/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class FunctionType
implements Type {
    public static final String NAME = "function";
    private final TypeSignature signature;
    private final Type returnType;
    private final List<Type> argumentTypes;

    public FunctionType(List<Type> argumentTypes, Type returnType) {
        this.signature = new TypeSignature(NAME, FunctionType.typeParameters(argumentTypes, returnType));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    private static List<TypeSignatureParameter> typeParameters(List<Type> argumentTypes, Type returnType) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        argumentTypes.stream().map(Type::getTypeSignature).map(TypeSignatureParameter::of).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        builder.add((Object)TypeSignatureParameter.of((TypeSignature)returnType.getTypeSignature()));
        return builder.build();
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public List<Type> getTypeParameters() {
        return ImmutableList.builder().addAll(this.argumentTypes).add((Object)this.returnType).build();
    }

    public final TypeSignature getTypeSignature() {
        return this.signature;
    }

    public String getDisplayName() {
        ImmutableList names = (ImmutableList)this.getTypeParameters().stream().map(Type::getDisplayName).collect(ImmutableList.toImmutableList());
        return "function<" + Joiner.on((String)",").join((Iterable)names) + ">";
    }

    public final Class<?> getJavaType() {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type does not have Java type");
    }

    public boolean isComparable() {
        return false;
    }

    public boolean isOrderable() {
        return false;
    }

    public long hash(Block block, int position) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not orderable");
    }

    public boolean getBoolean(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getLong(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void writeLong(BlockBuilder blockBuilder, long value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public double getDouble(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void writeDouble(BlockBuilder blockBuilder, double value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Slice getSlice(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object getObject(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        throw new UnsupportedOperationException();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        throw new UnsupportedOperationException();
    }
}

