/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.client.IntervalDayTime;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.AbstractLongType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class IntervalDayTimeOperators {
    private IntervalDayTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval day to second")
    public static long add(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByBigint(@SqlType(value="interval day to second") long left, @SqlType(value="bigint") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long bigintMultiply(@SqlType(value="bigint") long left, @SqlType(value="interval day to second") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval day to second") long right) {
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval day to second")
    public static long divideByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval day to second")
    public static long negate(@SqlType(value="interval day to second") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="interval day to second") long value, @SqlType(value="interval day to second") long min, @SqlType(value="interval day to second") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(@SqlType(value="interval day to second") long value) {
        return Slices.utf8Slice((String)IntervalDayTime.formatMillis((long)value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="interval day to second") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="interval day to second") long left, @IsNull boolean leftNull, @SqlType(value="interval day to second") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return IntervalDayTimeOperators.notEqual(left, right);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="interval day to second") long value, @IsNull boolean isNull) {
        return isNull;
    }
}

