/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

class TestClass
extends NoOpTestClass
implements ITestClass {
    private static final long serialVersionUID = -8077917128278361294L;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient ITestMethodFinder m_testMethodFinder = null;
    private IClass m_iClass = null;
    private RunInfo m_runInfo = null;
    private String m_testName;
    private XmlTest m_xmlTest;
    private XmlClass m_xmlClass;

    protected TestClass(IClass iClass, ITestMethodFinder iTestMethodFinder, IAnnotationFinder iAnnotationFinder, RunInfo runInfo, XmlTest xmlTest, XmlClass xmlClass) {
        this.init(iClass, iTestMethodFinder, iAnnotationFinder, runInfo, xmlTest, xmlClass);
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    private void init(IClass iClass, ITestMethodFinder iTestMethodFinder, IAnnotationFinder iAnnotationFinder, RunInfo runInfo, XmlTest xmlTest, XmlClass xmlClass) {
        this.log(3, "Creating TestClass for " + iClass);
        this.m_iClass = iClass;
        this.m_testClass = iClass.getRealClass();
        this.m_xmlTest = xmlTest;
        this.m_xmlClass = xmlClass;
        this.m_runInfo = runInfo;
        this.m_testMethodFinder = iTestMethodFinder;
        this.m_annotationFinder = iAnnotationFinder;
        this.initTestClassesAndInstances();
        this.initMethods();
    }

    private void initTestClassesAndInstances() {
        Object[] objectArray;
        for (Object object : objectArray = this.getInstances(false)) {
            if (!(object instanceof ITest)) continue;
            this.m_testName = ((ITest)object).getTestName();
            break;
        }
        if (this.m_testName == null) {
            this.m_testName = this.m_iClass.getTestName();
        }
    }

    @Override
    public Object[] getInstances(boolean bl) {
        return this.m_iClass.getInstances(bl);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_iClass.getInstanceHashCodes();
    }

    @Override
    @Deprecated
    public int getInstanceCount() {
        return this.m_iClass.getInstanceCount();
    }

    @Override
    public void addInstance(Object object) {
        this.m_iClass.addInstance(object);
    }

    private void initMethods() {
        ITestNGMethod[] iTestNGMethodArray = this.m_testMethodFinder.getTestMethods(this.m_testClass, this.m_xmlTest);
        this.m_testMethods = this.createTestMethods(iTestNGMethodArray);
        for (Object object : this.m_iClass.getInstances(false)) {
            this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.m_annotationFinder, true, object);
            this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.m_annotationFinder, false, object);
            this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, true, object);
            this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, false, object);
            this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getBeforeClassMethods(this.m_testClass), this.m_annotationFinder, true, object);
            this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getAfterClassMethods(this.m_testClass), this.m_annotationFinder, false, object);
            this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.m_testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, true, object);
            this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods(this.m_testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, false, object);
            this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getBeforeTestMethods(this.m_testClass), this.m_annotationFinder, true, object);
            this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getAfterTestMethods(this.m_testClass), this.m_annotationFinder, false, object);
        }
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] iTestNGMethodArray) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
            if (constructorOrMethod.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                for (Object object : this.m_iClass.getInstances(false)) {
                    this.log(4, "Adding method " + iTestNGMethod + " on TestClass " + this.m_testClass);
                    list.add(new TestNGMethod(constructorOrMethod.getMethod(), this.m_annotationFinder, this.m_xmlTest, object));
                }
                continue;
            }
            this.log(4, "Rejecting method " + iTestNGMethod + " for TestClass " + this.m_testClass);
        }
        ITestNGMethod[] iTestNGMethodArray2 = list.toArray(new ITestNGMethod[list.size()]);
        return iTestNGMethodArray2;
    }

    private RunInfo getRunInfo() {
        return this.m_runInfo;
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.m_testMethodFinder;
    }

    private void log(int n, String string) {
        Utils.log("TestClass", n, string);
    }

    private static void ppp(String string) {
        System.out.println("[TestClass] " + string);
    }

    protected void dump() {
        System.out.println("===== Test class\n" + this.m_testClass.getName());
        for (ITestNGMethod iTestNGMethod : this.m_beforeClassMethods) {
            System.out.println("  @BeforeClass " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_beforeTestMethods) {
            System.out.println("  @BeforeMethod " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_testMethods) {
            System.out.println("    @Test " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_afterTestMethods) {
            System.out.println("  @AfterMethod " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_afterClassMethods) {
            System.out.println("  @AfterClass " + iTestNGMethod);
        }
        System.out.println("======");
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_testClass).toString();
    }

    public IClass getIClass() {
        return this.m_iClass;
    }
}

