/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.testng.TestNGException;
import org.testng.collections.Lists;

public class PoolService<FutureType> {
    private ExecutorCompletionService<FutureType> m_completionService;
    private ThreadFactory m_threadFactory = new ThreadFactory(){
        private int m_threadIndex = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("PoolService-" + this.m_threadIndex);
            ++this.m_threadIndex;
            return thread;
        }
    };
    private ExecutorService m_executor;

    public PoolService(int n) {
        this.m_executor = Executors.newFixedThreadPool(n, this.m_threadFactory);
        this.m_completionService = new ExecutorCompletionService(this.m_executor);
    }

    public List<FutureType> submitTasksAndWait(List<? extends Callable<FutureType>> list) {
        List list2 = Lists.newArrayList();
        for (Callable<FutureType> object : list) {
            this.m_completionService.submit(object);
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                Future<FutureType> future = this.m_completionService.take();
                list2.add(future.get());
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new TestNGException(exception);
            }
        }
        this.m_executor.shutdown();
        return list2;
    }
}

