/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.StructuralTestUtil;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10)
@Fork(value=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapCopy {
    private static final int POSITIONS = 100000;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public BlockBuilder benchmarkMapCopy(BenchmarkData data) {
        Block block = data.getDataBlock();
        BlockBuilder blockBuilder = data.getBlockBuilder();
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        for (int i = 0; i < 100000; ++i) {
            mapType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder;
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkMapCopy().benchmarkMapCopy(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkMapCopy.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "2", "4", "8", "16"})
        private int mapSize;
        private Block dataBlock;
        private BlockBuilder blockBuilder;
        private BlockBuilderStatus status;

        @Setup
        public void setup() {
            MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
            this.blockBuilder = mapType.createBlockBuilder(null, 100000);
            for (int position = 0; position < 100000; ++position) {
                BlockBuilder entryBuilder = this.blockBuilder.beginBlockEntry();
                for (int i = 0; i < this.mapSize; ++i) {
                    VarcharType.VARCHAR.writeString(entryBuilder, String.valueOf(ThreadLocalRandom.current().nextInt()));
                    BigintType.BIGINT.writeLong(entryBuilder, (long)ThreadLocalRandom.current().nextInt());
                }
                this.blockBuilder.closeEntry();
            }
            this.dataBlock = this.blockBuilder.build();
        }

        public Block getDataBlock() {
            return this.dataBlock;
        }

        public BlockBuilder getBlockBuilder() {
            return this.blockBuilder.newBlockBuilderLike(this.status);
        }
    }
}

