/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.testng.Assert;

public final class BlockAssertions {
    private BlockAssertions() {
    }

    public static Object getOnlyValue(Type type, Block block) {
        Assert.assertEquals((int)block.getPositionCount(), (int)1, (String)"Block positions");
        return type.getObjectValue(TestingConnectorSession.SESSION, block, 0);
    }

    public static List<Object> toValues(Type type, Iterable<Block> blocks) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Block block : blocks) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                values.add(type.getObjectValue(TestingConnectorSession.SESSION, block, position));
            }
        }
        return Collections.unmodifiableList(values);
    }

    public static List<Object> toValues(Type type, Block block) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.add(type.getObjectValue(TestingConnectorSession.SESSION, block, position));
        }
        return Collections.unmodifiableList(values);
    }

    public static void assertBlockEquals(Type type, Block actual, Block expected) {
        Assert.assertEquals((int)actual.getPositionCount(), (int)expected.getPositionCount());
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(TestingConnectorSession.SESSION, actual, position), (Object)type.getObjectValue(TestingConnectorSession.SESSION, expected, position));
        }
    }

    public static Block createStringsBlock(String ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createStringsBlock(Arrays.asList(values));
    }

    public static Block createStringsBlock(Iterable<String> values) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeString(builder, value);
        }
        return builder.build();
    }

    public static Block createSlicesBlock(Slice ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createSlicesBlock(Arrays.asList(values));
    }

    public static Block createSlicesBlock(Iterable<Slice> values) {
        BlockBuilder builder = VarbinaryType.VARBINARY.createBlockBuilder(null, 100);
        for (Slice value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            VarbinaryType.VARBINARY.writeSlice(builder, value);
        }
        return builder.build();
    }

    public static Block createStringSequenceBlock(int start, int end) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 100);
        for (int i = start; i < end; ++i) {
            VarcharType.VARCHAR.writeString(builder, String.valueOf(i));
        }
        return builder.build();
    }

    public static Block createStringDictionaryBlock(int start, int length) {
        Preconditions.checkArgument((length > 5 ? 1 : 0) != 0, (Object)"block must have more than 5 entries");
        int dictionarySize = length / 5;
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, dictionarySize);
        for (int i = start; i < start + dictionarySize; ++i) {
            VarcharType.VARCHAR.writeString(builder, String.valueOf(i));
        }
        int[] ids = new int[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(builder.build(), ids);
    }

    public static Block createStringArraysBlock(Iterable<? extends Iterable<String>> values) {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        BlockBuilder builder = arrayType.createBlockBuilder(null, 100);
        for (Iterable<String> iterable : values) {
            if (iterable == null) {
                builder.appendNull();
                continue;
            }
            arrayType.writeObject(builder, (Object)BlockAssertions.createStringsBlock(iterable));
        }
        return builder.build();
    }

    public static Block createBooleansBlock(Boolean ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createBooleansBlock(Arrays.asList(values));
    }

    public static Block createBooleansBlock(Boolean value, int count) {
        return BlockAssertions.createBooleansBlock(Collections.nCopies(count, value));
    }

    public static Block createBooleansBlock(Iterable<Boolean> values) {
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(null, 100);
        for (Boolean value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            BooleanType.BOOLEAN.writeBoolean(builder, value.booleanValue());
        }
        return builder.build();
    }

    public static Block createShortDecimalsBlock(String ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createShortDecimalsBlock(Arrays.asList(values));
    }

    public static Block createShortDecimalsBlock(Iterable<String> values) {
        DecimalType shortDecimalType = DecimalType.createDecimalType((int)1);
        BlockBuilder builder = shortDecimalType.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            shortDecimalType.writeLong(builder, new BigDecimal(value).unscaledValue().longValue());
        }
        return builder.build();
    }

    public static Block createLongDecimalsBlock(String ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createLongDecimalsBlock(Arrays.asList(values));
    }

    public static Block createLongDecimalsBlock(Iterable<String> values) {
        DecimalType longDecimalType = DecimalType.createDecimalType((int)19);
        BlockBuilder builder = longDecimalType.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            Decimals.writeBigDecimal((DecimalType)longDecimalType, (BlockBuilder)builder, (BigDecimal)new BigDecimal(value));
        }
        return builder.build();
    }

    public static Block createIntsBlock(Integer ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createIntsBlock(Arrays.asList(values));
    }

    public static Block createIntsBlock(Iterable<Integer> values) {
        BlockBuilder builder = IntegerType.INTEGER.createBlockBuilder(null, 100);
        for (Integer value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            IntegerType.INTEGER.writeLong(builder, (long)value.intValue());
        }
        return builder.build();
    }

    public static Block createEmptyLongsBlock() {
        return BigintType.BIGINT.createFixedSizeBlockBuilder(0).build();
    }

    public static Block createLongsBlock(int ... values) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 100);
        for (int value : values) {
            BigintType.BIGINT.writeLong(builder, (long)value);
        }
        return builder.build();
    }

    public static Block createLongsBlock(Long ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createLongsBlock(Arrays.asList(values));
    }

    public static Block createLongsBlock(Iterable<Long> values) {
        return BlockAssertions.createTypedLongsBlock((Type)BigintType.BIGINT, values);
    }

    public static Block createTypedLongsBlock(Type type, Iterable<Long> values) {
        BlockBuilder builder = type.createBlockBuilder(null, 100);
        for (Long value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, value.longValue());
        }
        return builder.build();
    }

    public static Block createLongSequenceBlock(int start, int end) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static Block createLongDictionaryBlock(int start, int length) {
        Preconditions.checkArgument((length > 5 ? 1 : 0) != 0, (Object)"block must have more than 5 entries");
        int dictionarySize = length / 5;
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, dictionarySize);
        for (int i = start; i < start + dictionarySize; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)i);
        }
        int[] ids = new int[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(builder.build(), ids);
    }

    public static Block createLongRepeatBlock(int value, int length) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(length);
        for (int i = 0; i < length; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)value);
        }
        return builder.build();
    }

    public static Block createTimestampsWithTimezoneBlock(Long ... values) {
        BlockBuilder builder = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.createFixedSizeBlockBuilder(values.length);
        Long[] longArray = values;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long value = longArray[i];
            TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.writeLong(builder, value);
        }
        return builder.build();
    }

    public static Block createBooleanSequenceBlock(int start, int end) {
        BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            BooleanType.BOOLEAN.writeBoolean(builder, i % 2 == 0);
        }
        return builder.build();
    }

    public static Block createBlockOfReals(Float ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createBlockOfReals(Arrays.asList(values));
    }

    private static Block createBlockOfReals(Iterable<Float> values) {
        BlockBuilder builder = RealType.REAL.createBlockBuilder(null, 100);
        for (Float value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(value.floatValue()));
        }
        return builder.build();
    }

    public static Block createSequenceBlockOfReal(int start, int end) {
        BlockBuilder builder = RealType.REAL.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(i));
        }
        return builder.build();
    }

    public static Block createDoublesBlock(Double ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createDoublesBlock(Arrays.asList(values));
    }

    public static Block createDoublesBlock(Iterable<Double> values) {
        BlockBuilder builder = DoubleType.DOUBLE.createBlockBuilder(null, 100);
        for (Double value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            DoubleType.DOUBLE.writeDouble(builder, value.doubleValue());
        }
        return builder.build();
    }

    public static Block createDoubleSequenceBlock(int start, int end) {
        BlockBuilder builder = DoubleType.DOUBLE.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            DoubleType.DOUBLE.writeDouble(builder, (double)i);
        }
        return builder.build();
    }

    public static Block createArrayBigintBlock(Iterable<? extends Iterable<Long>> values) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        BlockBuilder builder = arrayType.createBlockBuilder(null, 100);
        for (Iterable<Long> iterable : values) {
            if (iterable == null) {
                builder.appendNull();
                continue;
            }
            arrayType.writeObject(builder, (Object)BlockAssertions.createLongsBlock(iterable));
        }
        return builder.build();
    }

    public static Block createDateSequenceBlock(int start, int end) {
        BlockBuilder builder = DateType.DATE.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            DateType.DATE.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static Block createTimestampSequenceBlock(int start, int end) {
        BlockBuilder builder = TimestampType.TIMESTAMP.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            TimestampType.TIMESTAMP.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static Block createShortDecimalSequenceBlock(int start, int end, DecimalType type) {
        BlockBuilder builder = type.createFixedSizeBlockBuilder(end - start);
        long base = BigInteger.TEN.pow(type.getScale()).longValue();
        for (int i = start; i < end; ++i) {
            type.writeLong(builder, base * (long)i);
        }
        return builder.build();
    }

    public static Block createLongDecimalSequenceBlock(int start, int end, DecimalType type) {
        BlockBuilder builder = type.createFixedSizeBlockBuilder(end - start);
        BigInteger base = BigInteger.TEN.pow(type.getScale());
        for (int i = start; i < end; ++i) {
            type.writeSlice(builder, Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(i).multiply(base)));
        }
        return builder.build();
    }

    public static RunLengthEncodedBlock createRLEBlock(double value, int positionCount) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        DoubleType.DOUBLE.writeDouble(blockBuilder, value);
        return new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
    }

    public static RunLengthEncodedBlock createRLEBlock(long value, int positionCount) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong(blockBuilder, value);
        return new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
    }
}

