/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.ByteArrayBlock;
import com.facebook.presto.spi.block.ByteArrayBlockBuilder;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestByteArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Object[] expectedValues = TestByteArrayBlock.createTestValue(17);
        this.assertFixedWithValues((Slice[])expectedValues);
        this.assertFixedWithValues((Slice[])TestByteArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = (Slice[])TestByteArrayBlock.alternatingNullValues(TestByteArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestByteArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestByteArrayBlock.createTestValue(100);
        ByteArrayBlockBuilder emptyBlockBuilder = new ByteArrayBlockBuilder(null, 0);
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, expectedValues.length);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestByteArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestByteArrayBlock.createTestValue(100);
        TestByteArrayBlock.assertEstimatedDataSizeForStats(TestByteArrayBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        byte[] byteArray = new byte[]{0, 0, 1, 2, 3, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestByteArrayBlock.testCompactBlock((Block)new ByteArrayBlock(0, Optional.empty(), new byte[0]));
        TestByteArrayBlock.testCompactBlock((Block)new ByteArrayBlock(byteArray.length, Optional.of(valueIsNull), byteArray));
        TestByteArrayBlock.testIncompactBlock((Block)new ByteArrayBlock(byteArray.length - 1, Optional.of(valueIsNull), byteArray));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        BlockBuilder blockBuilder = TestByteArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, expectedValues.length);
        TestByteArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeByte((int)expectedValue.getByte(0)).closeEntry();
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = Slices.wrappedBuffer((byte[])new byte[]{(byte)position});
        }
        return expectedValues;
    }

    @Override
    protected boolean isShortAccessSupported() {
        return false;
    }

    @Override
    protected boolean isIntAccessSupported() {
        return false;
    }

    @Override
    protected boolean isLongAccessSupported() {
        return false;
    }

    @Override
    protected boolean isSliceAccessSupported() {
        return false;
    }
}

