/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFixedWidthBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        for (int fixedSize = 0; fixedSize < 20; ++fixedSize) {
            Object[] expectedValues = TestFixedWidthBlock.createExpectedValues(17, fixedSize);
            this.assertFixedWithValues((Slice[])expectedValues, fixedSize);
            this.assertFixedWithValues((Slice[])TestFixedWidthBlock.alternatingNullValues(expectedValues), fixedSize);
        }
    }

    @Test
    public void testCopyPositions() {
        for (int fixedSize = 0; fixedSize < 20; ++fixedSize) {
            Slice[] expectedValues = (Slice[])TestFixedWidthBlock.alternatingNullValues(TestFixedWidthBlock.createExpectedValues(17, fixedSize));
            BlockBuilder blockBuilder = TestFixedWidthBlock.createBlockBuilderWithValues(expectedValues, fixedSize);
            this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 2, 4, 6, 7, 9, 10, 16);
        }
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        for (int fixedSize = 0; fixedSize < 20; ++fixedSize) {
            Slice[] expectedValues = (Slice[])TestFixedWidthBlock.alternatingNullValues(TestFixedWidthBlock.createExpectedValues(17, fixedSize));
            FixedWidthBlockBuilder emptyBlockBuilder = new FixedWidthBlockBuilder(fixedSize, null, 0);
            FixedWidthBlockBuilder blockBuilder = new FixedWidthBlockBuilder(fixedSize, null, expectedValues.length);
            Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
            Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
            TestFixedWidthBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
            Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
            Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
            blockBuilder = blockBuilder.newBlockBuilderLike(null);
            Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
            Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        }
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        for (int fixedSize = 0; fixedSize < 20; ++fixedSize) {
            Slice[] expectedValues = (Slice[])TestFixedWidthBlock.alternatingNullValues(TestFixedWidthBlock.createExpectedValues(17, fixedSize));
            FixedWidthBlockBuilder blockBuilder = new FixedWidthBlockBuilder(fixedSize, null, expectedValues.length);
            TestFixedWidthBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
            TestFixedWidthBlock.assertEstimatedDataSizeForStats((BlockBuilder)blockBuilder, expectedValues);
        }
    }

    @Test
    public void testCompactBlock() {
        Slice compactSlice = Slices.copyOf((Slice)TestFixedWidthBlock.createExpectedValue(24));
        Slice incompactSlice = Slices.copyOf((Slice)TestFixedWidthBlock.createExpectedValue(30)).slice(0, 24);
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestFixedWidthBlock.testCompactBlock((Block)new FixedWidthBlock(4, 0, Slices.EMPTY_SLICE, Optional.empty()));
        TestFixedWidthBlock.testCompactBlock((Block)new FixedWidthBlock(4, valueIsNull.length, compactSlice, Optional.of(Slices.wrappedBooleanArray((boolean[])valueIsNull))));
        TestFixedWidthBlock.testIncompactBlock((Block)new FixedWidthBlock(4, valueIsNull.length - 1, compactSlice, Optional.of(Slices.wrappedBooleanArray((boolean[])valueIsNull))));
        TestFixedWidthBlock.testIncompactBlock((Block)new FixedWidthBlock(4, valueIsNull.length, incompactSlice, Optional.of(Slices.wrappedBooleanArray((boolean[])valueIsNull))));
    }

    private void assertFixedWithValues(Slice[] expectedValues, int fixedSize) {
        BlockBuilder blockBuilder = TestFixedWidthBlock.createBlockBuilderWithValues(expectedValues, fixedSize);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues, int fixedSize) {
        FixedWidthBlockBuilder blockBuilder = new FixedWidthBlockBuilder(fixedSize, expectedValues.length);
        TestFixedWidthBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeBytes(expectedValue, 0, expectedValue.length()).closeEntry();
        }
    }

    private static Slice[] createExpectedValues(int positionCount, int fixedSize) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestFixedWidthBlock.createExpectedValue(fixedSize);
        }
        return expectedValues;
    }
}

