/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.ByteArrayBlock;
import com.facebook.presto.spi.block.MapBlockBuilder;
import com.facebook.presto.spi.block.SingleMapBlock;
import com.facebook.presto.spi.block.SingleMapBlockWriter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.StructuralTestUtil;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMapBlock
extends AbstractTestBlock {
    private static final TypeManager TYPE_MANAGER = new TypeRegistry();

    @Test
    public void test() {
        this.testWith(this.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock compactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock inCompactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        ByteArrayBlock inCompactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] mapIsNull = new boolean[]{false, true, false, false, false, false};
        TestMapBlock.testCompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(new boolean[0], new int[1], (Block)emptyBlock, (Block)emptyBlock));
        TestMapBlock.testCompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(mapIsNull, offsets, (Block)compactKeyBlock, (Block)compactValueBlock));
        TestMapBlock.testIncompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(mapIsNull, offsets, (Block)inCompactKeyBlock, (Block)inCompactValueBlock));
    }

    private Map<String, Long>[] createTestMap(int ... entryCounts) {
        Map[] result = new Map[entryCounts.length];
        for (int rowNumber = 0; rowNumber < entryCounts.length; ++rowNumber) {
            int entryCount = entryCounts[rowNumber];
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (int entryNumber = 0; entryNumber < entryCount; ++entryNumber) {
                map.put("key" + entryNumber, entryNumber == 5 ? null : Long.valueOf((long)rowNumber * 100L + (long)entryNumber));
            }
            result[rowNumber] = map;
        }
        return result;
    }

    private void testWith(Map<String, Long>[] expectedValues) {
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        Block block = this.createBlockWithValuesFromKeyValueBlock(expectedValues);
        this.assertBlock(block, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlockFilteredPositions(expectedValues, block, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, block, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        Map[] expectedValuesWithNull = (Map[])TestMapBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = this.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
        Block blockWithNull = this.createBlockWithValuesFromKeyValueBlock(expectedValuesWithNull);
        this.assertBlock(blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    private BlockBuilder createBlockBuilderWithValues(Map<String, Long>[] maps) {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
        for (Map<String, Long> map : maps) {
            this.createBlockBuilderWithValues(map, mapBlockBuilder);
        }
        return mapBlockBuilder;
    }

    private Block createBlockWithValuesFromKeyValueBlock(Map<String, Long>[] maps) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Long> values = new ArrayList<Long>();
        int[] offsets = new int[maps.length + 1];
        boolean[] mapIsNull = new boolean[maps.length];
        for (int i = 0; i < maps.length; ++i) {
            Map<String, Long> map = maps[i];
            boolean bl = mapIsNull[i] = map == null;
            if (map == null) {
                offsets[i + 1] = offsets[i];
                continue;
            }
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                keys.add(entry.getKey());
                values.add(entry.getValue());
            }
            offsets[i + 1] = offsets[i] + map.size();
        }
        return StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT).createBlockFromKeyValue(mapIsNull, offsets, BlockAssertions.createStringsBlock(keys), BlockAssertions.createLongsBlock(values));
    }

    private void createBlockBuilderWithValues(Map<String, Long> map, BlockBuilder mapBlockBuilder) {
        if (map == null) {
            mapBlockBuilder.appendNull();
        } else {
            BlockBuilder elementBlockBuilder = mapBlockBuilder.beginBlockEntry();
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                VarcharType.VARCHAR.writeSlice(elementBlockBuilder, Slices.utf8Slice((String)entry.getKey()));
                if (entry.getValue() == null) {
                    elementBlockBuilder.appendNull();
                    continue;
                }
                BigintType.BIGINT.writeLong(elementBlockBuilder, entry.getValue().longValue());
            }
            mapBlockBuilder.closeEntry();
        }
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue instanceof Map) {
            this.assertValue(block, position, (Map)expectedValue);
            return;
        }
        super.assertPositionValue(block, position, expectedValue);
    }

    private void assertValue(Block mapBlock, int position, Map<String, Long> map) {
        int i;
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        Objects.requireNonNull(map, "map is null");
        Assert.assertFalse((boolean)mapBlock.isNull(position));
        SingleMapBlock elementBlock = (SingleMapBlock)mapType.getObject(mapBlock, position);
        Assert.assertEquals((int)elementBlock.getPositionCount(), (int)(map.size() * 2));
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            int pos = elementBlock.seekKey((Object)Slices.utf8Slice((String)entry.getKey()));
            Assert.assertNotEquals((Object)pos, (Object)-1);
            if (entry.getValue() == null) {
                Assert.assertTrue((boolean)elementBlock.isNull(pos));
                continue;
            }
            Assert.assertFalse((boolean)elementBlock.isNull(pos));
            Assert.assertEquals((long)BigintType.BIGINT.getLong((Block)elementBlock, pos), (long)entry.getValue());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((int)elementBlock.seekKey((Object)Slices.utf8Slice((String)("not-inserted-" + i))), (int)-1);
        }
        for (i = 0; i < elementBlock.getPositionCount(); i += 2) {
            String actualKey = VarcharType.VARCHAR.getSlice((Block)elementBlock, i).toStringUtf8();
            Long actualValue = elementBlock.isNull(i + 1) ? null : Long.valueOf(BigintType.BIGINT.getLong((Block)elementBlock, i + 1));
            Assert.assertTrue((boolean)map.containsKey(actualKey));
            Assert.assertEquals((Object)actualValue, (Object)map.get(actualKey));
        }
    }

    @Test
    public void testCloseEntryStrict() throws Exception {
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 1);
        for (int i = 0; i < 100; ++i) {
            SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, 1L);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
            mapBlockBuilder.closeEntry();
        }
        SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < 50; ++i) {
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)i);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
        }
        mapBlockBuilder.closeEntryStrict();
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Map[] expectedValues = (Map[])TestMapBlock.alternatingNullValues(this.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(expectedValues);
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = TestMapBlock.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    private static int getExpectedEstimatedDataSize(Map<String, Long> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            size += entry.getKey().length();
            size += entry.getValue() == null ? 0 : 8;
        }
        return size;
    }

    static {
        new FunctionRegistry(TYPE_MANAGER, (BlockEncodingSerde)new BlockEncodingManager(TYPE_MANAGER, new BlockEncoding[0]), new FeaturesConfig());
    }
}

