/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostCalculatorUsingExchanges;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.FragmentedPlanCostCalculator;
import com.facebook.presto.cost.FragmentedPlanSourceProvider;
import com.facebook.presto.cost.FragmentedPlanStatsCalculator;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCostCalculator {
    private static final int NUMBER_OF_NODES = 10;
    private static final double AVERAGE_ROW_SIZE = 8.0;
    private static final double IS_NULL_OVERHEAD = 1.125;
    private static final double OFFSET_AND_IS_NULL_OVERHEAD = 1.625;
    private CostCalculator costCalculatorUsingExchanges;
    private CostCalculator costCalculatorWithEstimatedExchanges;
    private PlanFragmenter planFragmenter;
    private Session session;
    private MetadataManager metadata;
    private TransactionManager transactionManager;
    private FinalizerService finalizerService;
    private NodeScheduler nodeScheduler;
    private NodePartitioningManager nodePartitioningManager;

    @BeforeClass
    public void setUp() {
        this.costCalculatorUsingExchanges = new CostCalculatorUsingExchanges(() -> 10);
        this.costCalculatorWithEstimatedExchanges = new CostCalculatorWithEstimatedExchanges(this.costCalculatorUsingExchanges, () -> 10);
        this.planFragmenter = new PlanFragmenter(new QueryManagerConfig());
        this.session = TestingSession.testSessionBuilder().setCatalog("tpch").build();
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)"tpch"));
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)new InMemoryNodeManager(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(this.finalizerService));
        this.nodePartitioningManager = new NodePartitioningManager(this.nodeScheduler);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.costCalculatorUsingExchanges = null;
        this.costCalculatorWithEstimatedExchanges = null;
        this.planFragmenter = null;
        this.session = null;
        this.transactionManager = null;
        this.metadata = null;
        this.finalizerService.destroy();
        this.finalizerService = null;
        this.nodeScheduler.stop();
        this.nodeScheduler = null;
        this.nodePartitioningManager = null;
    }

    @Test
    public void testTableScan() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)tableScan, (Map<String, PlanNodeCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0)), (Map<String, Type>)types).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)tableScan, (Map<String, PlanNodeCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0)), (Map<String, Type>)types).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan((PlanNode)tableScan, (Map<String, PlanNodeCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0)), (Map<String, Type>)types).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)tableScan, (Map<String, Type>)types);
    }

    @Test
    public void testProject() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        PlanNode project = this.project("project", (PlanNode)tableScan, "string", (Expression)new Cast((Expression)new SymbolReference("orderkey"), "STRING"));
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)PlanNodeCostEstimate.cpuCost((double)1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"project", (Object)TestCostCalculator.statsEstimate(project, 4000.0), (Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"string", (Object)VarcharType.VARCHAR);
        this.assertCost(project, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges(project, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostFragmentedPlan(project, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats(project, (Map<String, Type>)types);
    }

    @Test
    public void testRepartitionedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.PARTITIONED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)PlanNodeCostEstimate.cpuCost((double)6000.0), (Object)"ts2", (Object)PlanNodeCostEstimate.cpuCost((double)1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(37375.0).memory(1125.0).network(7875.0);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join, (Map<String, Type>)types);
    }

    @Test
    public void testReplicatedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)PlanNodeCostEstimate.cpuCost((double)6000.0), (Object)"ts2", (Object)PlanNodeCostEstimate.cpuCost((double)1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(49750.0).memory(11250.0).network(11250.0);
        this.assertCostFragmentedPlan((PlanNode)join, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join, (Map<String, Type>)types);
    }

    @Test
    public void testAggregation() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        AggregationNode aggregation = this.aggregation("agg", (PlanNode)tableScan);
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)PlanNodeCostEstimate.cpuCost((double)6000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 6000.0), (Object)"agg", (Object)TestCostCalculator.statsEstimate((PlanNode)aggregation, 13.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"count", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)aggregation, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)aggregation, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(26250.0).memory(14.625).network(6750.0);
        this.assertCostFragmentedPlan((PlanNode)aggregation, (Map<String, PlanNodeCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)aggregation, (Map<String, Type>)types);
    }

    @Test
    public void testRepartitionedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        ExchangeNode remoteExchange1 = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("re1"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts1, (List)ImmutableList.of((Object)new Symbol("orderkey")), Optional.empty());
        ExchangeNode remoteExchange2 = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts2, (List)ImmutableList.of((Object)new Symbol("orderkey_0")), Optional.empty());
        ExchangeNode localExchange = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new Symbol("orderkey_0")), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)remoteExchange1, (PlanNode)localExchange, JoinNode.DistributionType.PARTITIONED, "orderkey", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re1", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange1, 10000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).build();
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types);
    }

    @Test
    public void testReplicatedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        ExchangeNode remoteExchange2 = ExchangeNode.replicatedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE, (PlanNode)ts2);
        ExchangeNode localExchange = ExchangeNode.partitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new Symbol("orderkey_0")), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)localExchange, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).build();
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types);
    }

    private CostAssertionBuilder assertCost(PlanNode node, Map<String, PlanNodeCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        return this.assertCost(this.costCalculatorUsingExchanges, node, costs, stats, types);
    }

    private CostAssertionBuilder assertCostEstimatedExchanges(PlanNode node, Map<String, PlanNodeCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        return this.assertCost(this.costCalculatorWithEstimatedExchanges, node, costs, stats, types);
    }

    private CostAssertionBuilder assertCostFragmentedPlan(PlanNode node, Map<String, PlanNodeCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue))));
        SubPlan subPlan = this.fragment(new Plan(node, typeProvider));
        FragmentedPlanSourceProvider sourceProvider = FragmentedPlanSourceProvider.create((List)subPlan.getAllFragments());
        FragmentedPlanCostCalculator costCalculator = new FragmentedPlanCostCalculator(this.costCalculatorUsingExchanges, sourceProvider, () -> 10);
        return this.assertCost((CostCalculator)costCalculator, node, costs, stats, types);
    }

    private CostAssertionBuilder assertCost(CostCalculator costCalculator, PlanNode node, Map<String, PlanNodeCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        PlanNodeCostEstimate cumulativeCost = this.calculateCumulativeCost(costCalculator, node, planNode -> (PlanNodeCostEstimate)costs.get(planNode.getId().toString()), planNode -> (PlanNodeStatsEstimate)stats.get(planNode.getId().toString()), types);
        return new CostAssertionBuilder(cumulativeCost);
    }

    private void assertCostHasUnknownComponentsForUnknownStats(PlanNode node, Map<String, Type> types) {
        new CostAssertionBuilder(this.calculateCumulativeCost(this.costCalculatorUsingExchanges, node, planNode -> PlanNodeCostEstimate.UNKNOWN_COST, planNode -> PlanNodeStatsEstimate.UNKNOWN_STATS, types)).hasUnknownComponents();
        new CostAssertionBuilder(this.calculateCumulativeCost(this.costCalculatorWithEstimatedExchanges, node, planNode -> PlanNodeCostEstimate.UNKNOWN_COST, planNode -> PlanNodeStatsEstimate.UNKNOWN_STATS, types)).hasUnknownComponents();
    }

    private void assertFragmentedEqualsUnfragmented(PlanNode node, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        StatsCalculator statsCalculator = this.statsCalculator(stats);
        PlanNodeCostEstimate costWithExchanges = this.calculateCumulativeCost(node, this.costCalculatorUsingExchanges, statsCalculator, types);
        PlanNodeCostEstimate costWithFragments = this.calculateCumulativeCostFragmentedPlan(node, statsCalculator, types);
        Assert.assertEquals((Object)costWithExchanges, (Object)costWithFragments);
    }

    private StatsCalculator statsCalculator(Map<String, PlanNodeStatsEstimate> stats) {
        return (node, sourceStats, lookup, session, types) -> (PlanNodeStatsEstimate)Objects.requireNonNull(stats.get(node.getId().toString()), "no stats for node");
    }

    private PlanNodeCostEstimate calculateCumulativeCost(CostCalculator costCalculator, PlanNode node, Function<PlanNode, PlanNodeCostEstimate> costs, Function<PlanNode, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        PlanNodeCostEstimate localCost = costCalculator.calculateCost(node, planNode -> (PlanNodeStatsEstimate)Objects.requireNonNull(stats.apply(planNode), "no stats for node"), Lookup.noLookup(), this.session, TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue)))));
        PlanNodeCostEstimate sourcesCost = node.getSources().stream().map(source -> (PlanNodeCostEstimate)Objects.requireNonNull(costs.apply((PlanNode)source), String.format("no cost for source: %s", source.getId()))).reduce(PlanNodeCostEstimate.ZERO_COST, PlanNodeCostEstimate::add);
        return sourcesCost.add(localCost);
    }

    private PlanNodeCostEstimate calculateCumulativeCost(PlanNode node, CostCalculator costCalculator, StatsCalculator statsCalculator, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue))));
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, this.session, typeProvider);
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, (StatsProvider)statsProvider, Optional.empty(), Lookup.noLookup(), this.session, typeProvider);
        return costProvider.getCumulativeCost(node);
    }

    private PlanNodeCostEstimate calculateCumulativeCostFragmentedPlan(PlanNode node, StatsCalculator statsCalculator, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf((Map)((Map)types.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new Symbol((String)entry.getKey()), Map.Entry::getValue))));
        SubPlan subPlan = this.fragment(new Plan(node, typeProvider));
        FragmentedPlanSourceProvider sourceProvider = FragmentedPlanSourceProvider.create((List)subPlan.getAllFragments());
        statsCalculator = new FragmentedPlanStatsCalculator(statsCalculator, sourceProvider);
        FragmentedPlanCostCalculator costCalculator = new FragmentedPlanCostCalculator(this.costCalculatorUsingExchanges, sourceProvider, () -> 10);
        return this.calculateCumulativeCost(node, (CostCalculator)costCalculator, statsCalculator, types);
    }

    private static PlanNodeStatsEstimate statsEstimate(PlanNode node, double outputSizeInBytes) {
        return TestCostCalculator.statsEstimate(node.getOutputSymbols(), outputSizeInBytes);
    }

    private static PlanNodeStatsEstimate statsEstimate(Collection<Symbol> symbols, double outputSizeInBytes) {
        Preconditions.checkArgument((symbols.size() > 0 ? 1 : 0) != 0, (Object)"No symbols");
        Preconditions.checkArgument((ImmutableSet.copyOf(symbols).size() == symbols.size() ? 1 : 0) != 0, (Object)"Duplicate symbols");
        double rowCount = outputSizeInBytes / (double)symbols.size() / 8.0;
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount);
        for (Symbol symbol : symbols) {
            builder.addSymbolStatistics(symbol, SymbolStatsEstimate.builder().setNullsFraction(0.0).setAverageRowSize(8.0).build());
        }
        return builder.build();
    }

    private TableScanNode tableScan(String id, String ... symbols) {
        List symbolsList = (List)Arrays.stream(symbols).map(Symbol::new).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (Symbol symbol : symbolsList) {
            assignments.put((Object)symbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT));
        }
        TpchTableHandle tableHandle = new TpchTableHandle("local", "orders", 1.0);
        return new TableScanNode(new PlanNodeId(id), new TableHandle(new ConnectorId("tpch"), (ConnectorTableHandle)new TpchTableHandle("local", "orders", 1.0)), symbolsList, (Map)assignments.build(), Optional.of(new TableLayoutHandle(new ConnectorId("tpch"), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, (ConnectorTableLayoutHandle)new TpchTableLayoutHandle(tableHandle, TupleDomain.all()))), TupleDomain.all());
    }

    private PlanNode project(String id, PlanNode source, String symbol, Expression expression) {
        return new ProjectNode(new PlanNodeId(id), source, Assignments.of((Symbol)new Symbol(symbol), (Expression)expression));
    }

    private AggregationNode aggregation(String id, PlanNode source) {
        AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), new Signature("count", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[0]), Optional.empty());
        return new AggregationNode(new PlanNodeId(id), source, (Map)ImmutableMap.of((Object)new Symbol("count"), (Object)aggregation), AggregationNode.singleGroupingSet((List)source.getOutputSymbols()), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
    }

    private JoinNode join(String planNodeId, PlanNode left, PlanNode right, JoinNode.DistributionType distributionType, String ... symbols) {
        Preconditions.checkArgument((symbols.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < symbols.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(new Symbol(symbols[i]), new Symbol(symbols[i + 1])));
        }
        return new JoinNode(new PlanNodeId(planNodeId), JoinNode.Type.INNER, left, right, (List)criteria.build(), (List)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(distributionType));
    }

    private SubPlan fragment(Plan plan) {
        return this.inTransaction(session -> this.planFragmenter.createSubPlans(session, (Metadata)this.metadata, this.nodePartitioningManager, plan, false));
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    private static class CostAssertionBuilder {
        private final PlanNodeCostEstimate actual;

        CostAssertionBuilder(PlanNodeCostEstimate actual) {
            this.actual = Objects.requireNonNull(actual, "actual is null");
        }

        CostAssertionBuilder cpu(double value) {
            Assert.assertEquals((double)this.actual.getCpuCost(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder memory(double value) {
            Assert.assertEquals((double)this.actual.getMemoryCost(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder network(double value) {
            Assert.assertEquals((double)this.actual.getNetworkCost(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder hasUnknownComponents() {
            Assert.assertTrue((boolean)this.actual.hasUnknownComponents());
            return this;
        }
    }
}

