/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.testing.TestingSession;
import com.google.common.base.Preconditions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCostComparator {
    @Test
    public void testCpuWeight() {
        new CostComparisonAssertion(1.0, 0.0, 0.0).smaller(200.0, 200.0, 200.0).larger(1000.0, 100.0, 100.0).assertCompare();
    }

    @Test
    public void testMemoryWeight() {
        new CostComparisonAssertion(0.0, 1.0, 0.0).smaller(200.0, 200.0, 200.0).larger(100.0, 1000.0, 100.0).assertCompare();
    }

    @Test
    public void testNetworkWeight() {
        new CostComparisonAssertion(0.0, 0.0, 1.0).smaller(200.0, 200.0, 200.0).larger(100.0, 100.0, 1000.0).assertCompare();
    }

    @Test
    public void testAllWeights() {
        new CostComparisonAssertion(1.0, 1.0, 1.0).smaller(333.0, 333.0, 333.0).larger(200.0, 300.0, 500.0).assertCompare();
        new CostComparisonAssertion(1.0, 1000.0, 1.0).smaller(300.0, 299.0, 300.0).larger(100.0, 300.0, 100.0).assertCompare();
    }

    @Test
    public void testUnknownCost() {
        CostComparator costComparator = new CostComparator(1.0, 1.0, 1.0);
        Session session = TestingSession.testSessionBuilder().build();
        Assert.assertThrows(IllegalArgumentException.class, () -> costComparator.compare(session, PlanNodeCostEstimate.ZERO_COST, PlanNodeCostEstimate.UNKNOWN_COST));
        Assert.assertThrows(IllegalArgumentException.class, () -> costComparator.compare(session, PlanNodeCostEstimate.UNKNOWN_COST, PlanNodeCostEstimate.ZERO_COST));
        Assert.assertThrows(IllegalArgumentException.class, () -> costComparator.compare(session, PlanNodeCostEstimate.UNKNOWN_COST, PlanNodeCostEstimate.UNKNOWN_COST));
    }

    private static class CostComparisonAssertion {
        private final CostComparator costComparator;
        private final Session session = TestingSession.testSessionBuilder().build();
        private PlanNodeCostEstimate smaller;
        private PlanNodeCostEstimate larger;

        public CostComparisonAssertion(double cpuWeight, double memoryWeight, double networkWeight) {
            this.costComparator = new CostComparator(cpuWeight, memoryWeight, networkWeight);
        }

        public void assertCompare() {
            Preconditions.checkState((this.smaller != null ? 1 : 0) != 0, (Object)"smaller not set");
            Preconditions.checkState((this.larger != null ? 1 : 0) != 0, (Object)"larger not set");
            Assert.assertTrue((this.costComparator.compare(this.session, this.smaller, this.larger) < 0 ? 1 : 0) != 0, (String)"smaller < larger is false");
            Assert.assertTrue((this.costComparator.compare(this.session, this.larger, this.smaller) > 0 ? 1 : 0) != 0, (String)"larger > smaller is false");
        }

        public CostComparisonAssertion smaller(double cpu, double memory, double network) {
            Preconditions.checkState((this.smaller == null ? 1 : 0) != 0, (Object)"already set");
            this.smaller = new PlanNodeCostEstimate(cpu, memory, network);
            return this;
        }

        public CostComparisonAssertion larger(double cpu, double memory, double network) {
            Preconditions.checkState((this.larger == null ? 1 : 0) != 0, (Object)"already set");
            this.larger = new PlanNodeCostEstimate(cpu, memory, network);
            return this;
        }
    }
}

