/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.FragmentedPlanSourceProvider;
import com.facebook.presto.cost.FragmentedPlanStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsCalculatorAssertion;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.StageExecutionStrategy;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchPartitioningHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFragmentedPlanStatsCalculator {
    private Metadata metadata;
    private Session session;

    @BeforeClass
    public void setUp() {
        this.metadata = MetadataManager.createTestMetadataManager();
        this.session = TestingSession.testSessionBuilder().build();
    }

    @AfterClass
    public void tearDown() {
        this.metadata = null;
        this.session = null;
    }

    @Test
    public void testRemoteSourceNodeStats() {
        PlanBuilder pb = new PlanBuilder(new PlanNodeIdAllocator(), this.metadata);
        ValuesNode values1 = pb.values(pb.symbol("i11", (Type)BigintType.BIGINT), pb.symbol("i12", (Type)BigintType.BIGINT), pb.symbol("i13", (Type)BigintType.BIGINT), pb.symbol("i14", (Type)BigintType.BIGINT));
        PlanFragment fragment1 = this.planFragment("f1", (PlanNode)values1, pb.getTypes().allTypes(), values1.getOutputSymbols());
        PlanNodeStatsEstimate values1Stats = PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics(new Symbol("i11"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.3).build()).addSymbolStatistics(new Symbol("i12"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i13"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).addSymbolStatistics(new Symbol("i14"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build();
        ValuesNode values2 = pb.values(pb.symbol("i21", (Type)BigintType.BIGINT), pb.symbol("i22", (Type)BigintType.BIGINT), pb.symbol("i23", (Type)BigintType.BIGINT), pb.symbol("i24", (Type)BigintType.BIGINT));
        PlanFragment fragment2 = this.planFragment("f2", (PlanNode)values2, pb.getTypes().allTypes(), values2.getOutputSymbols());
        PlanNodeStatsEstimate values2Stats = PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).addSymbolStatistics(new Symbol("i21"), SymbolStatsEstimate.builder().setLowValue(11.0).setHighValue(20.0).setNullsFraction(0.4).build()).addSymbolStatistics(new Symbol("i22"), SymbolStatsEstimate.builder().setLowValue(2.0).setHighValue(7.0).setDistinctValuesCount(3.0).build()).addSymbolStatistics(new Symbol("i23"), SymbolStatsEstimate.builder().setDistinctValuesCount(6.0).setNullsFraction(0.2).build()).addSymbolStatistics(new Symbol("i24"), SymbolStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build();
        ImmutableMap stats = ImmutableMap.builder().put((Object)values1, (Object)values1Stats).put((Object)values2, (Object)values2Stats).build();
        ImmutableList fragments = ImmutableList.of((Object)fragment1, (Object)fragment2);
        ImmutableList fragmentIds = (ImmutableList)fragments.stream().map(PlanFragment::getId).collect(ImmutableList.toImmutableList());
        RemoteSourceNode remoteSourceNode = pb.remoteSourceNode((List<PlanFragmentId>)fragmentIds, (List<Symbol>)ImmutableList.of((Object)pb.symbol("o1", (Type)BigintType.BIGINT), (Object)pb.symbol("o2", (Type)BigintType.BIGINT), (Object)pb.symbol("o3", (Type)BigintType.BIGINT), (Object)pb.symbol("o4", (Type)BigintType.BIGINT)), ExchangeNode.Type.REPARTITION);
        this.assertStatsFor((PlanNode)remoteSourceNode, (Map<PlanNode, PlanNodeStatsEstimate>)stats, (List<PlanFragment>)fragments, pb.getTypes()).check(check -> check.outputRowsCount(30.0).symbolStats("o1", assertion -> assertion.lowValue(1.0).highValue(20.0).distinctValuesCount(5.0).nullsFraction(0.3666666)).symbolStats("o2", assertion -> assertion.lowValue(0.0).highValue(7.0).distinctValuesCount(3.0).nullsFractionUnknown()).symbolStats("o3", assertion -> assertion.lowValueUnknown().highValueUnknown().distinctValuesCount(4.0).nullsFraction(0.1666667)).symbolStats("o4", assertion -> assertion.lowValue(10.0).highValue(15.0).distinctValuesCount(4.0).nullsFraction(0.1)));
    }

    private PlanFragment planFragment(String id, PlanNode root, Map<Symbol, Type> types, List<Symbol> outputLayout) {
        PartitioningHandle partitioningHandle = new PartitioningHandle(Optional.empty(), Optional.empty(), (ConnectorPartitioningHandle)new TpchPartitioningHandle("dummy", 100L));
        return new PlanFragment(new PlanFragmentId(id), root, types, partitioningHandle, Collections.emptyList(), new PartitioningScheme(Partitioning.create((PartitioningHandle)partitioningHandle, Collections.emptyList()), outputLayout), StageExecutionStrategy.ungroupedExecution());
    }

    private StatsCalculatorAssertion assertStatsFor(PlanNode node, Map<PlanNode, PlanNodeStatsEstimate> stats, List<PlanFragment> fragments, TypeProvider types) {
        StatsCalculator delegate = this.statsCalculator(stats);
        FragmentedPlanSourceProvider sourceProvider = FragmentedPlanSourceProvider.create(fragments);
        FragmentedPlanStatsCalculator statsCalculator = new FragmentedPlanStatsCalculator(delegate, sourceProvider);
        return new StatsCalculatorAssertion((StatsCalculator)statsCalculator, this.session, node, types).withSourceStats(stats);
    }

    private StatsCalculator statsCalculator(Map<PlanNode, PlanNodeStatsEstimate> stats) {
        return (node, sourceStats, lookup, session, types) -> (PlanNodeStatsEstimate)Objects.requireNonNull(stats.get(node), "no stats for node");
    }
}

