/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import org.testng.annotations.Test;

public class TestOutputNodeStats
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForOutputNode() {
        PlanNodeStatsEstimate stats = PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.0).setHighValue(30.0).setDistinctValuesCount(20.0).build()).addSymbolStatistics(new Symbol("b"), SymbolStatsEstimate.builder().setNullsFraction(0.6).setLowValue(13.5).setHighValue(Double.POSITIVE_INFINITY).setDistinctValuesCount(40.0).build()).build();
        this.tester().assertStatsFor(pb -> pb.output(outputBuilder -> {
            Symbol a = pb.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            outputBuilder.source((PlanNode)pb.values(a, b)).column(a, "a1").column(a, "a2").column(b, "b");
        })).withSourceStats(stats).check(outputStats -> outputStats.equalTo(stats));
    }
}

