/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.EstimateAssertion;
import com.facebook.presto.cost.StatisticRange;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStatisticRange {
    @Test
    public void testOverlapPercentWith() {
        StatisticRange zeroToTen = TestStatisticRange.range(0.0, 10.0, 10.0);
        StatisticRange empty = StatisticRange.empty();
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 5.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 20.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 20.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(5.0, 3000.0, 3.0), 0.5);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(3.0, 3.0, 1.0), 1.0 / zeroToTen.getDistinctValuesCount());
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(10.0, 100.0, 357.0), 1.0 / zeroToTen.getDistinctValuesCount());
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(20.0, 30.0, 10.0), 0.0);
        TestStatisticRange.assertOverlap(zeroToTen, empty, 0.0);
        TestStatisticRange.assertOverlap(empty, zeroToTen, 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(10.0), empty, 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(10.0), TestStatisticRange.unboundedRange(20.0), 1.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(20.0), TestStatisticRange.unboundedRange(10.0), 0.5);
    }

    @Test
    public void testIntersect() {
        StatisticRange zeroToTen = TestStatisticRange.range(0.0, 10.0, 10.0);
        StatisticRange fiveToFifteen = TestStatisticRange.range(5.0, 15.0, 60.0);
        Assert.assertEquals((Object)zeroToTen.intersect(fiveToFifteen), (Object)TestStatisticRange.range(5.0, 10.0, 10.0));
    }

    private static StatisticRange range(double low, double high, double distinctValues) {
        return new StatisticRange(low, high, distinctValues);
    }

    private static StatisticRange unboundedRange(double distinctValues) {
        return new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, distinctValues);
    }

    private static void assertOverlap(StatisticRange a, StatisticRange b, double expected) {
        EstimateAssertion.assertEstimateEquals(a.overlapPercentWith(b), expected, "overlapPercentWith", new Object[0]);
    }
}

