/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.SymbolStatsAssertion;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.testng.annotations.Test;

public class TestStatsNormalizer {
    private final TypeManager typeManager = new TypeRegistry();
    private final FunctionRegistry functionRegistry = new FunctionRegistry(this.typeManager, (BlockEncodingSerde)new BlockEncodingManager(this.typeManager, new BlockEncoding[0]), new FeaturesConfig());
    private final ConnectorSession session = new TestingConnectorSession(Collections.emptyList());
    private final StatsNormalizer normalizer = new StatsNormalizer();

    @Test
    public void testNoCapping() {
        Symbol a = new Symbol("a");
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().addSymbolStatistics(a, SymbolStatsEstimate.builder().setDistinctValuesCount(20.0).build()).build();
        this.assertNormalized(estimate).symbolStats(a, symbolAssert -> symbolAssert.distinctValuesCount(20.0));
    }

    @Test
    public void testDropNonOutputSymbols() {
        Symbol a = new Symbol("a");
        Symbol b = new Symbol("b");
        Symbol c = new Symbol("c");
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().addSymbolStatistics(a, SymbolStatsEstimate.builder().setDistinctValuesCount(20.0).build()).addSymbolStatistics(b, SymbolStatsEstimate.builder().setDistinctValuesCount(30.0).build()).addSymbolStatistics(c, SymbolStatsEstimate.buildFrom((SymbolStatsEstimate)SymbolStatsEstimate.UNKNOWN_STATS).build()).build();
        PlanNodeStatsAssertion.assertThat(this.normalizer.normalize(estimate, (Collection)ImmutableList.of((Object)b, (Object)c), TypeProvider.copyOf((Map)ImmutableMap.of((Object)b, (Object)BigintType.BIGINT, (Object)c, (Object)BigintType.BIGINT)))).symbolsWithKnownStats(b).symbolStats(b, symbolAssert -> symbolAssert.distinctValuesCount(30.0));
    }

    @Test
    public void tesCapDistinctValuesByOutputRowCount() {
        Symbol a = new Symbol("a");
        Symbol b = new Symbol("b");
        Symbol c = new Symbol("c");
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().addSymbolStatistics(a, SymbolStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(20.0).build()).addSymbolStatistics(b, SymbolStatsEstimate.builder().setNullsFraction(0.4).setDistinctValuesCount(20.0).build()).addSymbolStatistics(c, SymbolStatsEstimate.builder().build()).setOutputRowCount(10.0).build();
        this.assertNormalized(estimate).symbolStats(a, symbolAssert -> symbolAssert.distinctValuesCount(10.0)).symbolStats(b, symbolAssert -> symbolAssert.distinctValuesCount(8.0)).symbolStats(c, SymbolStatsAssertion::distinctValuesCountUnknown);
    }

    @Test
    public void testCapDistinctValuesByToDomainRangeLength() {
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 2.0E10, 1, 1000000000, 1.0E9);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, 3.0, 1, 5, 3.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)IntegerType.INTEGER, Double.NaN, 1, 5, Double.NaN);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BigintType.BIGINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)SmallintType.SMALLINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)TinyintType.TINYINT, 15.0, 1, 5, 5.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 11.0, 1, 1, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 13.0, 101, 103, 3.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DecimalType.createDecimalType((int)10, (int)2), 10.0, 100, 200, 10.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DoubleType.DOUBLE, 42.0, 10.1, 10.2, 42.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DoubleType.DOUBLE, 42.0, 10.1, 10.1, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BooleanType.BOOLEAN, 11.0, true, true, 1.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)BooleanType.BOOLEAN, 12.0, false, true, 2.0);
        this.testCapDistinctValuesByToDomainRangeLength((Type)DateType.DATE, 12.0, LocalDate.of(2017, 8, 31).toEpochDay(), LocalDate.of(2017, 9, 2).toEpochDay(), 3.0);
    }

    private void testCapDistinctValuesByToDomainRangeLength(Type type, double ndv, Object low, Object high, double expectedNormalizedNdv) {
        Symbol symbol = new Symbol("x");
        SymbolStatsEstimate symbolStats = SymbolStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(ndv).setLowValue(this.asStatsValue(low, type)).setHighValue(this.asStatsValue(high, type)).build();
        PlanNodeStatsEstimate estimate = PlanNodeStatsEstimate.builder().addSymbolStatistics(symbol, symbolStats).build();
        this.assertNormalized(estimate, TypeProvider.copyOf((Map)ImmutableMap.of((Object)symbol, (Object)type))).symbolStats(symbol, symbolAssert -> symbolAssert.distinctValuesCount(expectedNormalizedNdv));
    }

    private PlanNodeStatsAssertion assertNormalized(PlanNodeStatsEstimate estimate) {
        TypeProvider types = TypeProvider.copyOf((Map)((Map)estimate.getSymbolsWithKnownStatistics().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbol -> BigintType.BIGINT))));
        return this.assertNormalized(estimate, types);
    }

    private PlanNodeStatsAssertion assertNormalized(PlanNodeStatsEstimate estimate, TypeProvider types) {
        PlanNodeStatsEstimate normalized = this.normalizer.normalize(estimate, (Collection)estimate.getSymbolsWithKnownStatistics(), types);
        return PlanNodeStatsAssertion.assertThat(normalized);
    }

    private double asStatsValue(Object value, Type type) {
        return StatsUtil.toStatsRepresentation((FunctionRegistry)this.functionRegistry, (ConnectorSession)this.session, (Type)type, (Object)value).orElse(Double.NaN);
    }
}

