/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.FlatNetworkTopology;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.NodeSelector;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import io.airlift.concurrent.Threads;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=1)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkNodeScheduler {
    private static final int MAX_SPLITS_PER_NODE = 100;
    private static final int MAX_PENDING_SPLITS_PER_TASK_PER_NODE = 50;
    private static final int NODES = 200;
    private static final int DATA_NODES = 10000;
    private static final int RACKS = 400;
    private static final int SPLITS = 23200;
    private static final int SPLIT_BATCH_SIZE = 100;
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("test_connector_id");

    @Benchmark
    @OperationsPerInvocation(value=23200)
    public Object benchmark(BenchmarkData data) {
        ImmutableList remoteTasks = ImmutableList.copyOf(data.getTaskMap().values());
        Iterator finishingTask = Iterators.cycle(data.getTaskMap().values());
        Iterator<Split> splits = data.getSplits().iterator();
        HashSet<Split> batch = new HashSet<Split>();
        while (splits.hasNext() || !batch.isEmpty()) {
            Multimap assignments = data.getNodeSelector().computeAssignments(batch, (List)remoteTasks).getAssignments();
            for (Node node : assignments.keySet()) {
                MockRemoteTaskFactory.MockRemoteTask remoteTask = data.getTaskMap().get(node);
                remoteTask.addSplits((Multimap<PlanNodeId, Split>)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
                remoteTask.startSplits(100);
            }
            if (assignments.size() == batch.size()) {
                batch.clear();
            } else {
                batch.removeAll(assignments.values());
            }
            while (batch.size() < 100 && splits.hasNext()) {
                batch.add(splits.next());
            }
            ((MockRemoteTaskFactory.MockRemoteTask)finishingTask.next()).finishSplits((int)Math.ceil(2.0));
        }
        return remoteTasks;
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkNodeScheduler.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private static HostAddress addressForHost(int host) {
        int rack = Integer.hashCode(host) % 400;
        return HostAddress.fromParts((String)("host" + host + ".rack" + rack), (int)1);
    }

    private static class TestSplitRemote
    implements ConnectorSplit {
        private final List<HostAddress> hosts;

        public TestSplitRemote(int dataHost) {
            this.hosts = ImmutableList.of((Object)BenchmarkNodeScheduler.addressForHost(dataHost));
        }

        public boolean isRemotelyAccessible() {
            return true;
        }

        public List<HostAddress> getAddresses() {
            return this.hosts;
        }

        public Object getInfo() {
            return this;
        }
    }

    private static class BenchmarkNetworkTopology
    implements NetworkTopology {
        private BenchmarkNetworkTopology() {
        }

        public NetworkLocation locate(HostAddress address) {
            ArrayList parts = new ArrayList(ImmutableList.copyOf((Iterable)Splitter.on((String)".").split((CharSequence)address.getHostText())));
            Collections.reverse(parts);
            return NetworkLocation.create(parts);
        }

        public List<String> getLocationSegmentNames() {
            return ImmutableList.of((Object)"rack", (Object)"machine");
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"legacy", "benchmark", "flat"})
        private String topologyName = "legacy";
        private FinalizerService finalizerService = new FinalizerService();
        private NodeSelector nodeSelector;
        private Map<Node, MockRemoteTaskFactory.MockRemoteTask> taskMap = new HashMap<Node, MockRemoteTaskFactory.MockRemoteTask>();
        private List<Split> splits = new ArrayList<Split>();

        @Setup
        public void setup() {
            int i;
            TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
            this.finalizerService.start();
            NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
            ImmutableList.Builder nodeBuilder = ImmutableList.builder();
            for (int i2 = 0; i2 < 200; ++i2) {
                nodeBuilder.add((Object)new PrestoNode("node" + i2, URI.create("http://" + BenchmarkNodeScheduler.addressForHost(i2).getHostText()), NodeVersion.UNKNOWN, false));
            }
            ImmutableList nodes = nodeBuilder.build();
            MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remoteTaskExecutor-%s")), Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"remoteTaskScheduledExecutor-%s")));
            for (i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                ImmutableList.Builder initialSplits = ImmutableList.builder();
                for (int j = 0; j < 150; ++j) {
                    initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(i)));
                }
                TaskId taskId = new TaskId("test", 1, i);
                MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)initialSplits.build(), nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
                nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
                this.taskMap.put(node, remoteTask);
            }
            for (i = 0; i < 23200; ++i) {
                this.splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(ThreadLocalRandom.current().nextInt(10000))));
            }
            InMemoryNodeManager nodeManager = new InMemoryNodeManager();
            nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
            NodeScheduler nodeScheduler = new NodeScheduler(this.getNetworkTopology(), (InternalNodeManager)nodeManager, this.getNodeSchedulerConfig(), nodeTaskMap);
            this.nodeSelector = nodeScheduler.createNodeSelector(CONNECTOR_ID);
        }

        @TearDown
        public void tearDown() {
            this.finalizerService.destroy();
        }

        private NodeSchedulerConfig getNodeSchedulerConfig() {
            return new NodeSchedulerConfig().setMaxSplitsPerNode(100).setIncludeCoordinator(false).setNetworkTopology(this.topologyName).setMaxPendingSplitsPerTask(50);
        }

        private NetworkTopology getNetworkTopology() {
            Object topology;
            switch (this.topologyName) {
                case "legacy": {
                    topology = new LegacyNetworkTopology();
                    break;
                }
                case "flat": {
                    topology = new FlatNetworkTopology();
                    break;
                }
                case "benchmark": {
                    topology = new BenchmarkNetworkTopology();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return topology;
        }

        public Map<Node, MockRemoteTaskFactory.MockRemoteTask> getTaskMap() {
            return this.taskMap;
        }

        public NodeSelector getNodeSelector() {
            return this.nodeSelector;
        }

        public List<Split> getSplits() {
            return this.splits;
        }
    }
}

