/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.joda.time.DateTime;

public class MockQueryExecution
implements QueryExecution {
    private final List<StateMachine.StateChangeListener<QueryState>> listeners = new ArrayList<StateMachine.StateChangeListener<QueryState>>();
    private final DataSize memoryUsage;
    private final Duration cpuUsage;
    private final Session session;
    private final QueryId queryId;
    private QueryState state = QueryState.QUEUED;
    private Throwable failureCause;
    private Optional<ResourceGroupId> resourceGroupId;

    public MockQueryExecution(long memoryUsage) {
        this(memoryUsage, "query_id", 1);
    }

    public MockQueryExecution(long memoryUsage, String queryId, int priority) {
        this(memoryUsage, queryId, priority, new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    public MockQueryExecution(long memoryUsage, String queryId, int priority, Duration cpuUsage) {
        this.memoryUsage = DataSize.succinctBytes((long)memoryUsage);
        this.cpuUsage = cpuUsage;
        this.session = TestingSession.testSessionBuilder().setSystemProperty("query_priority", String.valueOf(priority)).build();
        this.resourceGroupId = Optional.empty();
        this.queryId = new QueryId(queryId);
    }

    public void complete() {
        this.state = QueryState.FINISHED;
        this.fireStateChange();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public QueryInfo getQueryInfo() {
        return new QueryInfo(new QueryId("test"), this.session.toSessionRepresentation(), this.state, new MemoryPoolId("test"), !this.state.isDone(), URI.create("http://test"), (List)ImmutableList.of(), "SELECT 1", new QueryStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new DateTime(4L), new Duration(6.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), new Duration(31.0, TimeUnit.NANOSECONDS), new Duration(7.0, TimeUnit.NANOSECONDS), new Duration(8.0, TimeUnit.NANOSECONDS), new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(200.0, TimeUnit.NANOSECONDS), 9, 10, 11, 12, 13, 15, 30, 16, 17.0, new DataSize(18.0, DataSize.Unit.BYTE), new DataSize(19.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(21.0, DataSize.Unit.BYTE), new DataSize(22.0, DataSize.Unit.BYTE), true, new Duration(20.0, TimeUnit.NANOSECONDS), new Duration(21.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), new DataSize(24.0, DataSize.Unit.BYTE), 25L, new DataSize(26.0, DataSize.Unit.BYTE), 27L, new DataSize(28.0, DataSize.Unit.BYTE), 29L, new DataSize(30.0, DataSize.Unit.BYTE), (List)ImmutableList.of(), (List)ImmutableList.of()), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, "", Optional.empty(), null, null, (Set)ImmutableSet.of(), Optional.empty(), this.state.isDone(), Optional.empty());
    }

    public QueryState getState() {
        return this.state;
    }

    public Plan getQueryPlan() {
        throw new UnsupportedOperationException();
    }

    public Throwable getThrowable() {
        return this.failureCause;
    }

    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return Futures.immediateFuture((Object)this.state);
    }

    public VersionedMemoryPoolId getMemoryPool() {
        throw new UnsupportedOperationException();
    }

    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        throw new UnsupportedOperationException();
    }

    public Session getSession() {
        return this.session;
    }

    public Optional<ErrorCode> getErrorCode() {
        return Optional.ofNullable(this.getQueryInfo().getFailureInfo()).map(ExecutionFailureInfo::getErrorCode);
    }

    public BasicQueryInfo getBasicQueryInfo() {
        return new BasicQueryInfo(this.getQueryInfo());
    }

    public DataSize getUserMemoryReservation() {
        return this.memoryUsage;
    }

    public DataSize getTotalMemoryReservation() {
        return this.memoryUsage;
    }

    public Duration getTotalCpuTime() {
        return this.cpuUsage;
    }

    public Optional<ResourceGroupId> getResourceGroup() {
        return this.resourceGroupId;
    }

    public void setResourceGroup(ResourceGroupId resourceGroupId) {
        this.resourceGroupId = Optional.of(Objects.requireNonNull(resourceGroupId, "resourceGroupId is null"));
    }

    public void start() {
        this.state = QueryState.RUNNING;
        this.fireStateChange();
    }

    public void fail(Throwable cause) {
        this.state = QueryState.FAILED;
        this.failureCause = cause;
        this.fireStateChange();
    }

    public boolean isDone() {
        return this.getState().isDone();
    }

    public void cancelQuery() {
        this.state = QueryState.FAILED;
        this.fireStateChange();
    }

    public void cancelStage(StageId stageId) {
        throw new UnsupportedOperationException();
    }

    public void recordHeartbeat() {
    }

    public void pruneInfo() {
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.listeners.add(stateChangeListener);
    }

    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        throw new UnsupportedOperationException();
    }

    private void fireStateChange() {
        for (StateMachine.StateChangeListener<QueryState> listener : this.listeners) {
            listener.stateChanged((Object)this.state);
        }
    }
}

