/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.LazyOutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.memory.DefaultQueryContext;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.StageExecutionStrategy;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.util.Failures;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.DateTime;

public class MockRemoteTaskFactory
implements RemoteTaskFactory {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutor;

    public MockRemoteTaskFactory(Executor executor, ScheduledExecutorService scheduledExecutor) {
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
    }

    public MockRemoteTask createTableScanTask(TaskId taskId, Node newNode, List<Split> splits, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker) {
        Symbol symbol = new Symbol("column");
        PlanNodeId sourceId = new PlanNodeId("sourceId");
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId("test"), (PlanNode)new TableScanNode(sourceId, new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle()), (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), Optional.empty(), TupleDomain.all()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)sourceId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StageExecutionStrategy.ungroupedExecution());
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split sourceSplit : splits) {
            initialSplits.put((Object)sourceId, (Object)sourceSplit);
        }
        return this.createRemoteTask(SessionTestUtils.TEST_SESSION, taskId, newNode, testFragment, (Multimap)initialSplits.build(), OptionalInt.empty(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.BROADCAST), partitionedSplitCountTracker, true);
    }

    public MockRemoteTask createRemoteTask(Session session, TaskId taskId, Node node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OptionalInt totalPartitions, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, boolean summarizeTaskInfo) {
        return new MockRemoteTask(taskId, fragment, node.getNodeIdentifier(), this.executor, this.scheduledExecutor, initialSplits, totalPartitions, partitionedSplitCountTracker);
    }

    public static final class MockRemoteTask
    implements RemoteTask {
        private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);
        private final URI location;
        private final TaskStateMachine taskStateMachine;
        private final TaskContext taskContext;
        private final OutputBuffer outputBuffer;
        private final String nodeId;
        private final PlanFragment fragment;
        @GuardedBy(value="this")
        private final Set<PlanNodeId> noMoreSplits = new HashSet<PlanNodeId>();
        @GuardedBy(value="this")
        private final Multimap<PlanNodeId, Split> splits = HashMultimap.create();
        @GuardedBy(value="this")
        private int runningDrivers;
        @GuardedBy(value="this")
        private SettableFuture<?> whenSplitQueueHasSpace = SettableFuture.create();
        private final NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker;

        public MockRemoteTask(TaskId taskId, PlanFragment fragment, String nodeId, Executor executor, ScheduledExecutorService scheduledExecutor, Multimap<PlanNodeId, Split> initialSplits, OptionalInt totalPartitions, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker) {
            this.taskStateMachine = new TaskStateMachine(Objects.requireNonNull(taskId, "taskId is null"), Objects.requireNonNull(executor, "executor is null"));
            MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
            SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE));
            DefaultQueryContext queryContext = new DefaultQueryContext(taskId.getQueryId(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(2.0, DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), executor, scheduledExecutor, new DataSize(1.0, DataSize.Unit.MEGABYTE), spillSpaceTracker);
            this.taskContext = queryContext.addTaskContext(this.taskStateMachine, SessionTestUtils.TEST_SESSION, true, true, totalPartitions);
            this.location = URI.create("fake://task/" + taskId);
            this.outputBuffer = new LazyOutputBuffer(taskId, MockRemoteTaskFactory.TASK_INSTANCE_ID, executor, new DataSize(1.0, DataSize.Unit.BYTE), () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"));
            this.fragment = Objects.requireNonNull(fragment, "fragment is null");
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            this.splits.putAll(initialSplits);
            this.partitionedSplitCountTracker = Objects.requireNonNull(partitionedSplitCountTracker, "partitionedSplitCountTracker is null");
            partitionedSplitCountTracker.setPartitionedSplitCount(this.getPartitionedSplitCount());
            this.updateSplitQueueSpace();
        }

        public TaskId getTaskId() {
            return this.taskStateMachine.getTaskId();
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public TaskInfo getTaskInfo() {
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures((Collection)this.taskStateMachine.getFailureCauses());
            }
            return new TaskInfo(new TaskStatus(this.taskStateMachine.getTaskId(), MockRemoteTaskFactory.TASK_INSTANCE_ID, this.nextTaskInfoVersion.getAndIncrement(), state, this.location, this.nodeId, (Set)ImmutableSet.of(), (List)failures, 0, 0, false, new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), 0L, new Duration(0.0, TimeUnit.MILLISECONDS)), DateTime.now(), this.outputBuffer.getInfo(), (Set)ImmutableSet.of(), this.taskContext.getTaskStats(), true, false);
        }

        public TaskStatus getTaskStatus() {
            TaskStats stats = this.taskContext.getTaskStats();
            return new TaskStatus(this.taskStateMachine.getTaskId(), MockRemoteTaskFactory.TASK_INSTANCE_ID, this.nextTaskInfoVersion.get(), this.taskStateMachine.getState(), this.location, this.nodeId, (Set)ImmutableSet.of(), (List)ImmutableList.of(), stats.getQueuedPartitionedDrivers(), stats.getRunningPartitionedDrivers(), false, stats.getPhysicalWrittenDataSize(), stats.getUserMemoryReservation(), stats.getSystemMemoryReservation(), 0L, new Duration(0.0, TimeUnit.MILLISECONDS));
        }

        private synchronized void updateSplitQueueSpace() {
            if (this.getQueuedPartitionedSplitCount() < 9) {
                if (!this.whenSplitQueueHasSpace.isDone()) {
                    this.whenSplitQueueHasSpace.set(null);
                }
            } else if (this.whenSplitQueueHasSpace.isDone()) {
                this.whenSplitQueueHasSpace = SettableFuture.create();
            }
        }

        public synchronized void finishSplits(int splits) {
            ArrayList toRemove = new ArrayList();
            Iterator iterator = this.splits.entries().iterator();
            while (toRemove.size() < splits && iterator.hasNext()) {
                toRemove.add(iterator.next());
            }
            for (Map.Entry entry : toRemove) {
                this.splits.remove(entry.getKey(), entry.getValue());
            }
            this.updateSplitQueueSpace();
        }

        public synchronized void clearSplits() {
            this.splits.clear();
            this.partitionedSplitCountTracker.setPartitionedSplitCount(this.getPartitionedSplitCount());
            this.runningDrivers = 0;
            this.updateSplitQueueSpace();
        }

        public synchronized void startSplits(int maxRunning) {
            this.runningDrivers = this.splits.size();
            this.runningDrivers = Math.min(this.runningDrivers, maxRunning);
            this.updateSplitQueueSpace();
        }

        public void start() {
            this.taskStateMachine.addStateChangeListener(newValue -> {
                if (newValue.isDone()) {
                    this.clearSplits();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSplits(Multimap<PlanNodeId, Split> splits) {
            MockRemoteTask mockRemoteTask = this;
            synchronized (mockRemoteTask) {
                this.splits.putAll(splits);
            }
            this.partitionedSplitCountTracker.setPartitionedSplitCount(this.getPartitionedSplitCount());
            this.updateSplitQueueSpace();
        }

        public synchronized void noMoreSplits(PlanNodeId sourceId) {
            this.noMoreSplits.add(sourceId);
            boolean allSourcesComplete = Stream.concat(this.fragment.getPartitionedSourceNodes().stream(), this.fragment.getRemoteSourceNodes().stream()).filter(Objects::nonNull).map(PlanNode::getId).allMatch(this.noMoreSplits::contains);
            if (allSourcesComplete) {
                this.taskStateMachine.finished();
            }
        }

        public void noMoreSplits(PlanNodeId sourceId, Lifespan lifespan) {
            throw new UnsupportedOperationException();
        }

        public void setOutputBuffers(OutputBuffers outputBuffers) {
            this.outputBuffer.setOutputBuffers(outputBuffers);
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<TaskStatus> stateChangeListener) {
            this.taskStateMachine.addStateChangeListener(newValue -> stateChangeListener.stateChanged((Object)this.getTaskStatus()));
        }

        public synchronized ListenableFuture<?> whenSplitQueueHasSpace(int threshold) {
            return Futures.nonCancellationPropagating(this.whenSplitQueueHasSpace);
        }

        public void cancel() {
            this.taskStateMachine.cancel();
        }

        public void abort() {
            this.taskStateMachine.abort();
            this.clearSplits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPartitionedSplitCount() {
            if (this.taskStateMachine.getState().isDone()) {
                return 0;
            }
            MockRemoteTask mockRemoteTask = this;
            synchronized (mockRemoteTask) {
                int count = 0;
                for (PlanNodeId partitionedSource : this.fragment.getPartitionedSources()) {
                    Collection partitionedSplits = this.splits.get((Object)partitionedSource);
                    count += partitionedSplits.size();
                }
                return count;
            }
        }

        public synchronized int getQueuedPartitionedSplitCount() {
            if (this.taskStateMachine.getState().isDone()) {
                return 0;
            }
            return this.getPartitionedSplitCount() - this.runningDrivers;
        }
    }
}

