/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.TaskSource;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.event.query.QueryMonitorConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TestSqlTaskManager;
import com.facebook.presto.execution.TestingPageSourceProvider;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.StageExecutionStrategy;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TestingTypeManager;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spiller.GenericSpillerFactory;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.util.FinalizerService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.node.NodeInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

public final class TaskTestUtils {
    private static final ConnectorTransactionHandle TRANSACTION_HANDLE = TestingTransactionHandle.create();
    public static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("tableScan");
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("test");
    public static final ScheduledSplit SPLIT = new ScheduledSplit(0L, TABLE_SCAN_NODE_ID, new Split(CONNECTOR_ID, TRANSACTION_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
    public static final ImmutableList<TaskSource> EMPTY_SOURCES = ImmutableList.of();
    public static final Symbol SYMBOL = new Symbol("column");
    public static final PlanFragment PLAN_FRAGMENT = new PlanFragment(new PlanFragmentId("fragment"), (PlanNode)new TableScanNode(TABLE_SCAN_NODE_ID, new TableHandle(CONNECTOR_ID, (ConnectorTableHandle)new TestingMetadata.TestingTableHandle()), (List)ImmutableList.of((Object)SYMBOL), (Map)ImmutableMap.of((Object)SYMBOL, (Object)new TestingMetadata.TestingColumnHandle("column", 0, (Type)BigintType.BIGINT)), Optional.empty(), TupleDomain.all()), (Map)ImmutableMap.of((Object)SYMBOL, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)SYMBOL)).withBucketToPartition(Optional.of(new int[1])), StageExecutionStrategy.ungroupedExecution());

    private TaskTestUtils() {
    }

    public static LocalExecutionPlanner createTestingPlanner() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageSourceManager pageSourceManager = new PageSourceManager();
        pageSourceManager.addConnectorPageSourceProvider(CONNECTOR_ID, (ConnectorPageSourceProvider)new TestingPageSourceProvider());
        FinalizerService finalizerService = new FinalizerService();
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)new InMemoryNodeManager(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(finalizerService));
        NodePartitioningManager nodePartitioningManager = new NodePartitioningManager(nodeScheduler);
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        return new LocalExecutionPlanner((Metadata)metadata, new SqlParser(), Optional.empty(), (PageSourceProvider)pageSourceManager, new IndexManager(), nodePartitioningManager, new PageSinkManager(), (ExchangeClientSupplier)new TestSqlTaskManager.MockExchangeClientSupplier(), new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler), pageFunctionCompiler, new JoinFilterFunctionCompiler((Metadata)metadata), new IndexJoinLookupStats(), new TaskManagerConfig(), (SpillerFactory)new GenericSpillerFactory((types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }), (types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (types, partitionFunction, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TestingTypeManager(), new BlockEncoding[0]), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()), new LookupJoinOperators(), new OrderingCompiler());
    }

    public static TaskInfo updateTask(SqlTask sqlTask, List<TaskSource> taskSources, OutputBuffers outputBuffers) {
        return sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(PLAN_FRAGMENT), taskSources, outputBuffers, OptionalInt.empty());
    }

    public static QueryMonitor createTestQueryMonitor() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        return new QueryMonitor(new ObjectMapperProvider().get(), JsonCodec.jsonCodec(StageInfo.class), new EventListenerManager(), new NodeInfo("test"), new NodeVersion("testVersion"), new SessionPropertyManager(), (Metadata)metadata, new QueryMonitorConfig(), (StatsCalculator)new ComposableStatsCalculator((List)ImmutableList.of()), (node, stats, lookup, session, types) -> PlanNodeCostEstimate.UNKNOWN_COST, (InternalNodeManager)new InMemoryNodeManager(), new NodeSchedulerConfig().setIncludeCoordinator(true));
    }
}

