/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.CreateTableTask;
import com.facebook.presto.metadata.AbstractMockMetadata;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.ColumnPropertyManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateTableTask {
    private static final String CATALOG_NAME = "catalog";
    private CatalogManager catalogManager;
    private TypeManager typeManager;
    private TransactionManager transactionManager;
    private TablePropertyManager tablePropertyManager;
    private ColumnPropertyManager columnPropertyManager;
    private Catalog testCatalog;
    private Session testSession;
    private MockMetadata metadata;

    @BeforeMethod
    public void setUp() {
        this.catalogManager = new CatalogManager();
        this.typeManager = new TypeRegistry();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)this.catalogManager);
        this.tablePropertyManager = new TablePropertyManager();
        this.columnPropertyManager = new ColumnPropertyManager();
        this.testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        this.catalogManager.registerCatalog(this.testCatalog);
        this.tablePropertyManager.addProperties(this.testCatalog.getConnectorId(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)));
        this.columnPropertyManager.addProperties(this.testCatalog.getConnectorId(), (List)ImmutableList.of());
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(this.transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata(this.typeManager, this.tablePropertyManager, this.columnPropertyManager, this.testCatalog.getConnectorId());
    }

    @Test
    public void testCreateTableNotExistsTrue() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), "BIGINT", Collections.emptyList(), Optional.empty())), true, (List)ImmutableList.of(), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    @Test
    public void testCreateTableNotExistsFalse() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), "BIGINT", Collections.emptyList(), Optional.empty())), false, (List)ImmutableList.of(), Optional.empty());
        try {
            MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e instanceof PrestoException));
            PrestoException prestoException = (PrestoException)((Object)e);
            Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode());
        }
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final TypeManager typeManager;
        private final TablePropertyManager tablePropertyManager;
        private final ColumnPropertyManager columnPropertyManager;
        private final ConnectorId catalogHandle;
        private AtomicInteger createTableCallCount = new AtomicInteger();

        public MockMetadata(TypeManager typeManager, TablePropertyManager tablePropertyManager, ColumnPropertyManager columnPropertyManager, ConnectorId catalogHandle) {
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
            this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        }

        @Override
        public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
            this.createTableCallCount.incrementAndGet();
            if (!ignoreExisting) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists");
            }
        }

        @Override
        public TablePropertyManager getTablePropertyManager() {
            return this.tablePropertyManager;
        }

        @Override
        public ColumnPropertyManager getColumnPropertyManager() {
            return this.columnPropertyManager;
        }

        @Override
        public Type getType(TypeSignature signature) {
            return this.typeManager.getType(signature);
        }

        @Override
        public Optional<ConnectorId> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            return Optional.empty();
        }

        public int getCreateTableCallCount() {
            return this.createTableCallCount.get();
        }

        @Override
        public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
            throw new UnsupportedOperationException();
        }
    }
}

