/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.DeallocateTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestDeallocateTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testDeallocate() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT bar, baz FROM foo").build();
        Set<String> statements = this.executeDeallocate("my_query", "DEALLOCATE PREPARE my_query", session);
        Assert.assertEquals(statements, (Set)ImmutableSet.of((Object)"my_query"));
    }

    @Test
    public void testDeallocateNoSuchStatement() {
        try {
            this.executeDeallocate("my_query", "DEALLOCATE PREPARE my_query", SessionTestUtils.TEST_SESSION);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)"Prepared statement not found: my_query");
        }
    }

    private Set<String> executeDeallocate(String statementName, String sqlString, Session session) {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControl = new AccessControlManager(transactionManager);
        QueryStateMachine stateMachine = QueryStateMachine.begin((QueryId)new QueryId("query"), (String)sqlString, (Session)session, (URI)URI.create("fake://uri"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Metadata)this.metadata);
        Deallocate deallocate = new Deallocate(new Identifier(statementName));
        new DeallocateTask().execute(deallocate, transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList());
        return stateMachine.getDeallocatedPreparedStatements();
    }
}

