/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.testing.TestingTicker;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestQueryStateMachine {
    private static final QueryId QUERY_ID = new QueryId("query_id");
    private static final String QUERY = "sql";
    private static final URI LOCATION = URI.create("fake://fake-query");
    private static final SQLException FAILED_CAUSE = new SQLException("FAILED");
    private static final List<Input> INPUTS = ImmutableList.of((Object)new Input(new ConnectorId("connector"), "schema", "table", Optional.empty(), (List)ImmutableList.of((Object)new Column("a", "varchar"))));
    private static final Optional<Output> OUTPUT = Optional.empty();
    private static final List<String> OUTPUT_FIELD_NAMES = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
    private static final List<Type> OUTPUT_FIELD_TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    private static final String UPDATE_TYPE = "update type";
    private static final VersionedMemoryPoolId MEMORY_POOL = new VersionedMemoryPoolId(new MemoryPoolId("pool"), 42L);
    private static final Map<String, String> SET_SESSION_PROPERTIES = ImmutableMap.builder().put((Object)"fruit", (Object)"apple").put((Object)"drink", (Object)"coffee").build();
    private static final List<String> RESET_SESSION_PROPERTIES = ImmutableList.of((Object)"candy");
    private final ExecutorService executor = Executors.newCachedThreadPool();

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testBasicStateChanges() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testStateChangesWithResourceWaiting() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        Assert.assertTrue((boolean)stateMachine.transitionToWaitingForResources());
        TestQueryStateMachine.assertState(stateMachine, QueryState.WAITING_FOR_RESOURCES);
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testQueued() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testPlanning() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testStarting() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertFalse((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToStarting();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToStarting();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testRunning() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testFinished() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testFailed() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FAILED, FAILED_CAUSE);
    }

    @Test
    public void testCanceled() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FAILED, (Exception)((Object)new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "canceled")));
    }

    @Test
    public void testPlanningTimeDuration() {
        TestingTicker mockTicker = new TestingTicker();
        QueryStateMachine stateMachine = this.createQueryStateMachineWithTicker((Ticker)mockTicker);
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        mockTicker.increment(100L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        mockTicker.increment(500L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        mockTicker.increment(300L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        mockTicker.increment(200L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stateMachine.transitionToFinishing());
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        QueryStats queryStats = stateMachine.getQueryInfo(Optional.empty()).getQueryStats();
        Assert.assertTrue((queryStats.getQueuedTime().toMillis() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((queryStats.getTotalPlanningTime().toMillis() == 500L ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateMemoryUsage() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        stateMachine.updateMemoryUsage(5L, 10L, 3L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)5L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)10L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)3L);
        stateMachine.updateMemoryUsage(0L, 0L, 2L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)5L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)10L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)3L);
        stateMachine.updateMemoryUsage(1L, 1L, 5L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)6L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)11L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)5L);
        stateMachine.updateMemoryUsage(3L, 3L, 2L);
        Assert.assertEquals((long)stateMachine.getPeakUserMemoryInBytes(), (long)9L);
        Assert.assertEquals((long)stateMachine.getPeakTotalMemoryInBytes(), (long)14L);
        Assert.assertEquals((long)stateMachine.getPeakTaskTotalMemory(), (long)5L);
    }

    private static void assertFinalState(QueryStateMachine stateMachine, QueryState expectedState) {
        TestQueryStateMachine.assertFinalState(stateMachine, expectedState, null);
    }

    private static void assertFinalState(QueryStateMachine stateMachine, QueryState expectedState, Exception expectedException) {
        Assert.assertTrue((boolean)expectedState.isDone());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToPlanning());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToStarting());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToFinishing());
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish")));
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
    }

    private static void assertState(QueryStateMachine stateMachine, QueryState expectedState) {
        TestQueryStateMachine.assertState(stateMachine, expectedState, null);
    }

    private static void assertState(QueryStateMachine stateMachine, QueryState expectedState, Exception expectedException) {
        Assert.assertEquals((Object)stateMachine.getQueryId(), (Object)QUERY_ID);
        TestQueryStateMachine.assertEqualSessionsWithoutTransactionId(stateMachine.getSession(), SessionTestUtils.TEST_SESSION);
        Assert.assertSame((Object)stateMachine.getMemoryPool(), (Object)MEMORY_POOL);
        Assert.assertEquals((Map)stateMachine.getSetSessionProperties(), SET_SESSION_PROPERTIES);
        Assert.assertEquals((Collection)stateMachine.getResetSessionProperties(), RESET_SESSION_PROPERTIES);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assert.assertEquals((Object)queryInfo.getQueryId(), (Object)QUERY_ID);
        Assert.assertEquals((Object)queryInfo.getSelf(), (Object)LOCATION);
        Assert.assertFalse((boolean)queryInfo.getOutputStage().isPresent());
        Assert.assertEquals((String)queryInfo.getQuery(), (String)QUERY);
        Assert.assertEquals((Collection)queryInfo.getInputs(), INPUTS);
        Assert.assertEquals((Object)queryInfo.getOutput(), OUTPUT);
        Assert.assertEquals((Collection)queryInfo.getFieldNames(), OUTPUT_FIELD_NAMES);
        Assert.assertEquals((String)queryInfo.getUpdateType(), (String)UPDATE_TYPE);
        Assert.assertEquals((Object)queryInfo.getMemoryPool(), (Object)MEMORY_POOL.getId());
        QueryStats queryStats = queryInfo.getQueryStats();
        if (queryInfo.getState() == QueryState.QUEUED) {
            Assert.assertNull((Object)queryStats.getTotalPlanningTime());
            Assert.assertNull((Object)queryStats.getExecutionStartTime());
            Assert.assertNull((Object)queryStats.getFinishingTime());
            Assert.assertNull((Object)queryStats.getEndTime());
        } else if (queryInfo.getState() == QueryState.WAITING_FOR_RESOURCES) {
            Assert.assertNotNull((Object)queryStats.getQueuedTime());
            Assert.assertNull((Object)queryStats.getResourceWaitingTime());
            Assert.assertNull((Object)queryStats.getTotalPlanningTime());
            Assert.assertNull((Object)queryStats.getExecutionStartTime());
            Assert.assertNull((Object)queryStats.getFinishingTime());
            Assert.assertNull((Object)queryStats.getEndTime());
        } else if (queryInfo.getState() == QueryState.PLANNING) {
            Assert.assertNotNull((Object)queryStats.getQueuedTime());
            Assert.assertNotNull((Object)queryStats.getResourceWaitingTime());
            Assert.assertNull((Object)queryStats.getTotalPlanningTime());
            Assert.assertNull((Object)queryStats.getExecutionStartTime());
            Assert.assertNull((Object)queryStats.getFinishingTime());
            Assert.assertNull((Object)queryStats.getEndTime());
        } else if (queryInfo.getState() == QueryState.STARTING) {
            Assert.assertNotNull((Object)queryStats.getQueuedTime());
            Assert.assertNotNull((Object)queryStats.getResourceWaitingTime());
            Assert.assertNotNull((Object)queryStats.getTotalPlanningTime());
            Assert.assertNull((Object)queryStats.getExecutionStartTime());
            Assert.assertNull((Object)queryStats.getFinishingTime());
            Assert.assertNull((Object)queryStats.getEndTime());
        } else if (queryInfo.getState() == QueryState.RUNNING) {
            Assert.assertNotNull((Object)queryStats.getQueuedTime());
            Assert.assertNotNull((Object)queryStats.getResourceWaitingTime());
            Assert.assertNotNull((Object)queryStats.getTotalPlanningTime());
            Assert.assertNotNull((Object)queryStats.getExecutionStartTime());
            Assert.assertNull((Object)queryStats.getFinishingTime());
            Assert.assertNull((Object)queryStats.getEndTime());
        } else if (queryInfo.getState() == QueryState.FINISHING) {
            Assert.assertNotNull((Object)queryStats.getQueuedTime());
            Assert.assertNotNull((Object)queryStats.getResourceWaitingTime());
            Assert.assertNotNull((Object)queryStats.getTotalPlanningTime());
            Assert.assertNotNull((Object)queryStats.getExecutionStartTime());
            Assert.assertNull((Object)queryStats.getFinishingTime());
            Assert.assertNull((Object)queryStats.getEndTime());
        } else {
            Assert.assertNotNull((Object)queryStats.getQueuedTime());
            Assert.assertNotNull((Object)queryStats.getResourceWaitingTime());
            Assert.assertNotNull((Object)queryStats.getTotalPlanningTime());
            Assert.assertNotNull((Object)queryStats.getExecutionStartTime());
            Assert.assertNotNull((Object)queryStats.getFinishingTime());
            Assert.assertNotNull((Object)queryStats.getEndTime());
        }
        Assert.assertEquals((Object)stateMachine.getQueryState(), (Object)expectedState);
        Assert.assertEquals((Object)queryInfo.getState(), (Object)expectedState);
        Assert.assertEquals((boolean)stateMachine.isDone(), (boolean)expectedState.isDone());
        if (expectedState == QueryState.FAILED) {
            FailureInfo failure = queryInfo.getFailureInfo().toFailureInfo();
            Assert.assertNotNull((Object)failure);
            Assert.assertEquals((String)failure.getType(), (String)expectedException.getClass().getName());
            if (expectedException instanceof PrestoException) {
                Assert.assertEquals((Object)queryInfo.getErrorCode(), (Object)((PrestoException)((Object)expectedException)).getErrorCode());
            } else {
                Assert.assertEquals((Object)queryInfo.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
            }
        } else {
            Assert.assertNull((Object)queryInfo.getFailureInfo());
        }
    }

    private QueryStateMachine createQueryStateMachine() {
        return this.createQueryStateMachineWithTicker(Ticker.systemTicker());
    }

    private QueryStateMachine createQueryStateMachineWithTicker(Ticker ticker) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControl = new AccessControlManager(transactionManager);
        QueryStateMachine stateMachine = QueryStateMachine.beginWithTicker((QueryId)QUERY_ID, (String)QUERY, (Session)SessionTestUtils.TEST_SESSION, (URI)LOCATION, (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)this.executor, (Ticker)ticker, (Metadata)metadata);
        stateMachine.setInputs(INPUTS);
        stateMachine.setOutput(OUTPUT);
        stateMachine.setColumns(OUTPUT_FIELD_NAMES, OUTPUT_FIELD_TYPES);
        stateMachine.setUpdateType(UPDATE_TYPE);
        stateMachine.setMemoryPool(MEMORY_POOL);
        for (Map.Entry<String, String> entry : SET_SESSION_PROPERTIES.entrySet()) {
            stateMachine.addSetSessionProperties(entry.getKey(), entry.getValue());
        }
        RESET_SESSION_PROPERTIES.forEach(arg_0 -> ((QueryStateMachine)stateMachine).addResetSessionProperties(arg_0));
        return stateMachine;
    }

    private static void assertEqualSessionsWithoutTransactionId(Session actual, Session expected) {
        Assert.assertEquals((Object)actual.getQueryId(), (Object)expected.getQueryId());
        Assert.assertEquals((Object)actual.getIdentity(), (Object)expected.getIdentity());
        Assert.assertEquals((Object)actual.getSource(), (Object)expected.getSource());
        Assert.assertEquals((Object)actual.getCatalog(), (Object)expected.getCatalog());
        Assert.assertEquals((Object)actual.getSchema(), (Object)expected.getSchema());
        Assert.assertEquals((Object)actual.getTimeZoneKey(), (Object)expected.getTimeZoneKey());
        Assert.assertEquals((Object)actual.getLocale(), (Object)expected.getLocale());
        Assert.assertEquals((Object)actual.getRemoteUserAddress(), (Object)expected.getRemoteUserAddress());
        Assert.assertEquals((Object)actual.getUserAgent(), (Object)expected.getUserAgent());
        Assert.assertEquals((long)actual.getStartTime(), (long)expected.getStartTime());
        Assert.assertEquals((Map)actual.getSystemProperties(), (Map)expected.getSystemProperties());
        Assert.assertEquals((Map)actual.getConnectorProperties(), (Map)expected.getConnectorProperties());
    }
}

