/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SetPathTask;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.ColumnPropertyManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.PathElement;
import com.facebook.presto.sql.tree.PathSpecification;
import com.facebook.presto.sql.tree.SetPath;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetPathTask {
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final MetadataManager metadata;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    public TestSetPathTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = new MetadataManager(new FeaturesConfig(), (TypeManager)new TypeRegistry(), (BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]), new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), this.transactionManager);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSetPath() {
        PathSpecification pathSpecification = new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.empty(), new Identifier("foo"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH foo");
        this.executeSetPathTask(pathSpecification, stateMachine);
        Assert.assertEquals((String)stateMachine.getSetPath(), (String)"foo");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Catalog does not exist: .*")
    public void testSetPathInvalidCatalog() {
        PathSpecification invalidPathSpecification = new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.of(new Identifier("invalidCatalog")), new Identifier("thisDoesNotMatter"))));
        QueryStateMachine stateMachine = this.createQueryStateMachine("SET PATH invalidCatalog.thisDoesNotMatter");
        this.executeSetPathTask(invalidPathSpecification, stateMachine);
    }

    private QueryStateMachine createQueryStateMachine(String query) {
        return QueryStateMachine.begin((QueryId)new QueryId("query"), (String)query, (Session)SessionTestUtils.TEST_SESSION, (URI)URI.create("fake://uri"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata);
    }

    private void executeSetPathTask(PathSpecification pathSpecification, QueryStateMachine stateMachine) {
        MoreFutures.getFutureValue((Future)new SetPathTask().execute(new SetPath(pathSpecification), this.transactionManager, (Metadata)this.metadata, this.accessControl, stateMachine, Collections.emptyList()));
    }
}

