/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.ColumnPropertyManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.SchemaPropertyManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetSessionTask {
    private static final String CATALOG_NAME = "foo";
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final MetadataManager metadata;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    public TestSetSessionTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = new MetadataManager(new FeaturesConfig(), (TypeManager)new TypeRegistry(), (BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]), new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), this.transactionManager);
        this.metadata.getSessionPropertyManager().addSystemSessionProperty(PropertyMetadata.stringProperty((String)CATALOG_NAME, (String)"test property", null, (boolean)false));
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        this.metadata.getSessionPropertyManager().addConnectorSessionProperties(bogusTestingCatalog.getConnectorId(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"bar", (String)"test property", null, (boolean)false)));
        catalogManager.registerCatalog(bogusTestingCatalog);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSetSession() {
        this.testSetSession((Expression)new StringLiteral("baz"), "baz");
        this.testSetSession((Expression)new FunctionCall(QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral("ban"), (Object)new StringLiteral("ana"))), "banana");
    }

    @Test
    public void testSetSessionWithParameters() {
        ArrayList<Object> expressionList = new ArrayList<Object>();
        expressionList.add(new StringLiteral("ban"));
        expressionList.add(new Parameter(0));
        this.testSetSessionWithParameters((Expression)new FunctionCall(QualifiedName.of((String)"concat"), expressionList), "banana", (List<Expression>)ImmutableList.of((Object)new StringLiteral("ana")));
    }

    private void testSetSession(Expression expression, String expectedValue) {
        this.testSetSessionWithParameters(expression, expectedValue, Collections.emptyList());
    }

    private void testSetSessionWithParameters(Expression expression, String expectedValue, List<Expression> parameters) {
        QueryStateMachine stateMachine = QueryStateMachine.begin((QueryId)new QueryId("query"), (String)"set foo.bar = 'baz'", (Session)SessionTestUtils.TEST_SESSION, (URI)URI.create("fake://uri"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata);
        MoreFutures.getFutureValue((Future)new SetSessionTask().execute(new SetSession(QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"bar"}), expression), this.transactionManager, (Metadata)this.metadata, this.accessControl, stateMachine, parameters));
        Map sessionProperties = stateMachine.getSetSessionProperties();
        Assert.assertEquals((Map)sessionProperties, (Map)ImmutableMap.of((Object)"foo.bar", (Object)expectedValue));
    }
}

