/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStateMachine;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.operator.StageExecutionStrategy;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestStageStateMachine {
    private static final StageId STAGE_ID = new StageId("query", 0);
    private static final URI LOCATION = URI.create("fake://fake-stage");
    private static final PlanFragment PLAN_FRAGMENT = TestStageStateMachine.createValuesPlan();
    private static final SQLException FAILED_CAUSE = new SQLException("FAILED");
    private final ExecutorService executor = Executors.newCachedThreadPool();

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testBasicStateChanges() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assert.assertTrue((boolean)stateMachine.transitionToScheduled());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULED);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testPlanned() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        TestStageStateMachine.assertState(stateMachine, StageState.PLANNED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageStateMachine.assertState(stateMachine, StageState.ABORTED);
        stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageStateMachine.assertState(stateMachine, StageState.CANCELED);
    }

    @Test
    public void testScheduling() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULING);
        Assert.assertTrue((boolean)stateMachine.transitionToScheduled());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageStateMachine.assertState(stateMachine, StageState.ABORTED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduling();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageStateMachine.assertState(stateMachine, StageState.CANCELED);
    }

    @Test
    public void testScheduled() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToScheduled());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULED);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULED);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduled());
        TestStageStateMachine.assertState(stateMachine, StageState.SCHEDULED);
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageStateMachine.assertState(stateMachine, StageState.ABORTED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToScheduled();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageStateMachine.assertState(stateMachine, StageState.CANCELED);
    }

    @Test
    public void testRunning() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduled());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, StageState.RUNNING);
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, StageState.FINISHED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, StageState.FAILED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageStateMachine.assertState(stateMachine, StageState.ABORTED);
        stateMachine = this.createStageStateMachine();
        stateMachine.transitionToRunning();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageStateMachine.assertState(stateMachine, StageState.CANCELED);
    }

    @Test
    public void testFinished() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FINISHED);
    }

    @Test
    public void testFailed() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertFinalState(stateMachine, StageState.FAILED);
    }

    @Test
    public void testAborted() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToAborted());
        TestStageStateMachine.assertFinalState(stateMachine, StageState.ABORTED);
    }

    @Test
    public void testCanceled() {
        StageStateMachine stateMachine = this.createStageStateMachine();
        Assert.assertTrue((boolean)stateMachine.transitionToCanceled());
        TestStageStateMachine.assertFinalState(stateMachine, StageState.CANCELED);
    }

    private static void assertFinalState(StageStateMachine stateMachine, StageState expectedState) {
        Assert.assertTrue((boolean)expectedState.isDone());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduling());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToScheduled());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToRunning());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFinished());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)FAILED_CAUSE));
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToAborted());
        TestStageStateMachine.assertState(stateMachine, expectedState);
        Assert.assertFalse((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish")));
        TestStageStateMachine.assertState(stateMachine, expectedState);
    }

    private static void assertState(StageStateMachine stateMachine, StageState expectedState) {
        Assert.assertEquals((Object)stateMachine.getStageId(), (Object)STAGE_ID);
        Assert.assertEquals((Object)stateMachine.getLocation(), (Object)LOCATION);
        Assert.assertSame((Object)stateMachine.getSession(), (Object)SessionTestUtils.TEST_SESSION);
        StageInfo stageInfo = stateMachine.getStageInfo(ImmutableList::of, ImmutableList::of);
        Assert.assertEquals((Object)stageInfo.getStageId(), (Object)STAGE_ID);
        Assert.assertEquals((Object)stageInfo.getSelf(), (Object)LOCATION);
        Assert.assertEquals((Collection)stageInfo.getSubStages(), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)stageInfo.getTasks(), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)stageInfo.getTypes(), (Collection)ImmutableList.of((Object)VarcharType.VARCHAR));
        Assert.assertSame((Object)stageInfo.getPlan(), (Object)PLAN_FRAGMENT);
        Assert.assertEquals((Object)stateMachine.getState(), (Object)expectedState);
        Assert.assertEquals((Object)stageInfo.getState(), (Object)expectedState);
        if (expectedState == StageState.FAILED) {
            ExecutionFailureInfo failure = stageInfo.getFailureCause();
            Assert.assertEquals((String)failure.getMessage(), (String)FAILED_CAUSE.getMessage());
            Assert.assertEquals((String)failure.getType(), (String)FAILED_CAUSE.getClass().getName());
        } else {
            Assert.assertNull((Object)stageInfo.getFailureCause());
        }
    }

    private StageStateMachine createStageStateMachine() {
        return new StageStateMachine(STAGE_ID, LOCATION, SessionTestUtils.TEST_SESSION, PLAN_FRAGMENT, this.executor, new SplitSchedulerStats());
    }

    private static PlanFragment createValuesPlan() {
        Symbol symbol = new Symbol("column");
        PlanNodeId valuesNodeId = new PlanNodeId("plan");
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId("plan"), (PlanNode)new ValuesNode(valuesNodeId, (List)ImmutableList.of((Object)symbol), (List)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("foo")))), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)valuesNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StageExecutionStrategy.ungroupedExecution());
        return planFragment;
    }
}

