/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.StateMachine;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestStateMachine {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testNullState() {
        try {
            new StateMachine("test", (Executor)this.executor, null);
            Assert.fail((String)"expected a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST);
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.set(null);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.compareAndSet((Object)State.BREAKFAST, null);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.compareAndSet((Object)State.LUNCH, null);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.setIf(null, currentState -> true);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.setIf(null, currentState -> false);
                Assert.fail((String)"expected a NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testSet() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)State.BREAKFAST));
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.BREAKFAST), (Object)((Object)State.BREAKFAST)));
        this.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.LUNCH), (Object)((Object)State.BREAKFAST)), State.LUNCH);
        this.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.BREAKFAST), (Object)((Object)State.LUNCH)), State.BREAKFAST);
        this.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertEquals((Object)stateMachine.set((Object)State.DINNER), (Object)((Object)State.BREAKFAST)), State.DINNER);
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.set((Object)State.LUNCH);
                Assert.fail((String)"expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            State cfr_ignored_0 = (State)((Object)((Object)stateMachine.set((Object)State.DINNER)));
        });
    }

    @Test
    public void testCompareAndSet() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)State.BREAKFAST));
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.DINNER, (Object)State.LUNCH));
        this.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.BREAKFAST, (Object)State.LUNCH), State.LUNCH);
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.BREAKFAST, (Object)State.LUNCH));
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.LUNCH, (Object)State.LUNCH));
        this.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.LUNCH, (Object)State.DINNER), State.DINNER);
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.compareAndSet((Object)State.DINNER, (Object)State.LUNCH);
                Assert.fail((String)"expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.compareAndSet((Object)State.DINNER, (Object)State.DINNER));
    }

    @Test
    public void testSetIf() throws Exception {
        StateMachine stateMachine = new StateMachine("test", (Executor)this.executor, (Object)State.BREAKFAST, (Iterable)ImmutableSet.of((Object)((Object)State.DINNER)));
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)State.BREAKFAST));
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertFalse((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.BREAKFAST));
            return false;
        })));
        this.assertStateChange((StateMachine<State>)stateMachine, () -> Assert.assertTrue((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.BREAKFAST));
            return true;
        })), State.LUNCH);
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertFalse((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.LUNCH));
            return false;
        })));
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> Assert.assertFalse((boolean)stateMachine.setIf((Object)State.LUNCH, currentState -> {
            Assert.assertEquals((Object)currentState, (Object)((Object)State.LUNCH));
            return true;
        })));
        this.assertStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.DINNER, currentState -> true), State.DINNER);
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> {
            try {
                stateMachine.setIf((Object)State.LUNCH, currentState -> true);
                Assert.fail((String)"expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.LUNCH, currentState -> false));
        this.assertNoStateChange((StateMachine<State>)stateMachine, () -> stateMachine.setIf((Object)State.DINNER, currentState -> true));
    }

    private void assertStateChange(StateMachine<State> stateMachine, StateChanger stateChange, State expectedState) throws Exception {
        State initialState = (State)((Object)stateMachine.get());
        ListenableFuture futureChange = stateMachine.getStateChange((Object)initialState);
        SettableFuture listenerChange = SettableFuture.create();
        stateMachine.addStateChangeListener(arg_0 -> ((SettableFuture)listenerChange).set(arg_0));
        stateChange.run();
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)expectedState));
        Assert.assertEquals((Object)futureChange.get(1L, TimeUnit.SECONDS), (Object)((Object)expectedState));
        Assert.assertEquals((Object)listenerChange.get(1L, TimeUnit.SECONDS), (Object)((Object)expectedState));
        boolean isTerminalState = stateMachine.isTerminalState((Object)expectedState);
        if (isTerminalState) {
            Assert.assertEquals((Collection)stateMachine.getStateChangeListeners(), (Collection)ImmutableSet.of());
        }
    }

    private void assertNoStateChange(StateMachine<State> stateMachine, StateChanger stateChange) {
        State initialState = (State)((Object)stateMachine.get());
        ListenableFuture futureChange = stateMachine.getStateChange((Object)initialState);
        SettableFuture listenerChange = SettableFuture.create();
        stateMachine.addStateChangeListener(arg_0 -> ((SettableFuture)listenerChange).set(arg_0));
        boolean isTerminalState = stateMachine.isTerminalState((Object)initialState);
        if (isTerminalState) {
            Assert.assertEquals((Collection)stateMachine.getStateChangeListeners(), (Collection)ImmutableSet.of());
        }
        stateChange.run();
        Assert.assertEquals((Object)stateMachine.get(), (Object)((Object)initialState));
        Assert.assertEquals((boolean)futureChange.isDone(), (boolean)isTerminalState);
        futureChange.cancel(true);
        Assert.assertEquals((boolean)listenerChange.isDone(), (boolean)isTerminalState);
        listenerChange.cancel(true);
    }

    private static interface StateChanger {
        public void run();
    }

    private static enum State {
        BREAKFAST,
        LUNCH,
        DINNER;

    }
}

