/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.testing.TestingSession;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUnwrapExecute {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void testSelectStatement() {
        Statement statement = SQL_PARSER.createStatement("SELECT * FROM foo");
        Assert.assertEquals((Object)SqlQueryManager.unwrapExecuteStatement((Statement)statement, (SqlParser)SQL_PARSER, (Session)SessionTestUtils.TEST_SESSION), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatement() {
        Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo").build();
        Statement statement = SQL_PARSER.createStatement("EXECUTE my_query");
        Assert.assertEquals((Object)SqlQueryManager.unwrapExecuteStatement((Statement)statement, (SqlParser)SQL_PARSER, (Session)session), (Object)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo"))));
    }

    @Test
    public void testExecuteStatementDoesNotExist() {
        try {
            Statement statement = SQL_PARSER.createStatement("execute my_query");
            SqlQueryManager.unwrapExecuteStatement((Statement)statement, (SqlParser)SQL_PARSER, (Session)SessionTestUtils.TEST_SESSION);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_FOUND.toErrorCode());
        }
    }

    @Test
    public void testTooManyParameters() {
        try {
            Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT * FROM foo where col1 = ?").build();
            Statement statement = SQL_PARSER.createStatement("EXECUTE my_query USING 1,2");
            SqlQueryManager.validateParameters((Statement)SqlQueryManager.unwrapExecuteStatement((Statement)statement, (SqlParser)SQL_PARSER, (Session)session), (List)((Execute)statement).getParameters());
            Assert.fail((String)"expected exception");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
    }

    @Test
    public void testTooFewParameters() {
        try {
            Session session = TestingSession.testSessionBuilder().addPreparedStatement("my_query", "SELECT ? FROM foo where col1 = ?").build();
            Statement statement = SQL_PARSER.createStatement("EXECUTE my_query USING 1");
            SqlQueryManager.validateParameters((Statement)SqlQueryManager.unwrapExecuteStatement((Statement)statement, (SqlParser)SQL_PARSER, (Session)session), (List)((Execute)statement).getParameters());
            Assert.fail((String)"expected exception");
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)SemanticErrorCode.INVALID_PARAMETER_USAGE);
        }
    }
}

