/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;

class Histogram<K extends Comparable<K>> {
    private final List<K> buckets;
    private final boolean discrete;

    private Histogram(Collection<K> buckets, boolean discrete) {
        this.buckets = new ArrayList<K>(buckets);
        this.discrete = discrete;
        Collections.sort(this.buckets);
    }

    public static <K extends Comparable<K>> Histogram<K> fromDiscrete(Collection<K> buckets) {
        return new Histogram<K>(buckets, true);
    }

    public static <K extends Comparable<K>> Histogram<K> fromContinuous(Collection<K> buckets) {
        return new Histogram<K>(buckets, false);
    }

    public static <D> Histogram<Long> fromContinuous(Collection<D> initialData, Function<D, Long> keyFunction) {
        if (initialData.isEmpty()) {
            return new Histogram<Long>((Collection<Long>)ImmutableList.of(), false);
        }
        int numBuckets = Math.min(10, (int)Math.sqrt(initialData.size()));
        long min = initialData.stream().mapToLong(keyFunction::apply).min().getAsLong();
        long max = initialData.stream().mapToLong(keyFunction::apply).max().getAsLong();
        Preconditions.checkArgument((max > min ? 1 : 0) != 0);
        long bucketSize = (max - min) / (long)numBuckets;
        long bucketRemainder = (max - min) % (long)numBuckets;
        ArrayList<Long> minimums = new ArrayList<Long>();
        long currentMin = min;
        for (int i = 0; i < numBuckets; ++i) {
            minimums.add(currentMin);
            long currentMax = currentMin + bucketSize;
            if (bucketRemainder > 0L) {
                ++currentMax;
                --bucketRemainder;
            }
            currentMin = currentMax + 1L;
        }
        minimums.add(numBuckets, currentMin);
        return new Histogram<Long>(minimums, false);
    }

    public <D, F> void printDistribution(Collection<D> data, Function<D, K> keyFunction, Function<K, F> keyFormatter) {
        if (this.buckets.isEmpty()) {
            System.out.println("No buckets");
            return;
        }
        if (data.isEmpty()) {
            System.out.println("No data");
            return;
        }
        long[] bucketData = new long[this.buckets.size()];
        block0: for (D datum : data) {
            Comparable key = (Comparable)keyFunction.apply(datum);
            for (int i = 0; i < this.buckets.size(); ++i) {
                if (key.compareTo(this.buckets.get(i)) < 0 || i != this.buckets.size() - 1 && key.compareTo(this.buckets.get(i + 1)) >= 0) continue;
                int n = i;
                bucketData[n] = bucketData[n] + 1L;
                continue block0;
            }
        }
        if (!this.discrete) {
            for (int i = 0; i < bucketData.length - 1; ++i) {
                System.out.printf("%8s - %8s : (%5s values)\n", keyFormatter.apply(this.buckets.get(i)), keyFormatter.apply(this.buckets.get(i + 1)), bucketData[i]);
            }
        } else {
            for (int i = 0; i < bucketData.length; ++i) {
                System.out.printf("%8s : (%5s values)\n", keyFormatter.apply(this.buckets.get(i)), bucketData[i]);
            }
        }
    }

    public <D, V, F, G> void printDistribution(Collection<D> data, Function<D, K> keyFunction, Function<D, V> valueFunction, Function<K, F> keyFormatter, Function<List<V>, G> valueFormatter) {
        if (this.buckets.isEmpty()) {
            System.out.println("No buckets");
            return;
        }
        if (data.isEmpty()) {
            System.out.println("No data");
            return;
        }
        TreeMap bucketData = new TreeMap();
        for (int i = 0; i < this.buckets.size(); ++i) {
            bucketData.put(i, new ArrayList());
        }
        block1: for (D datum : data) {
            Comparable key = (Comparable)keyFunction.apply(datum);
            V value = valueFunction.apply(datum);
            for (int i = 0; i < this.buckets.size(); ++i) {
                if (key.compareTo(this.buckets.get(i)) < 0 || i != this.buckets.size() - 1 && key.compareTo(this.buckets.get(i + 1)) >= 0) continue;
                ((List)bucketData.get(i)).add(value);
                continue block1;
            }
        }
        if (!this.discrete) {
            for (int i = 0; i < bucketData.size() - 1; ++i) {
                System.out.printf("%8s - %8s : (%5s values) %s\n", keyFormatter.apply(this.buckets.get(i)), keyFormatter.apply(this.buckets.get(i + 1)), ((List)bucketData.get(i)).size(), valueFormatter.apply((List<V>)bucketData.get(i)));
            }
        } else {
            for (int i = 0; i < bucketData.size(); ++i) {
                System.out.printf("%19s : (%5s values) %s\n", keyFormatter.apply(this.buckets.get(i)), ((List)bucketData.get(i)).size(), valueFormatter.apply((List<V>)bucketData.get(i)));
            }
        }
    }
}

