/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.facebook.presto.execution.executor.Histogram;
import com.facebook.presto.execution.executor.MultilevelSplitQueue;
import com.facebook.presto.execution.executor.SimulationController;
import com.facebook.presto.execution.executor.SimulationTask;
import com.facebook.presto.execution.executor.SplitGenerators;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class TaskExecutorSimulator
implements Closeable {
    private final ListeningExecutorService submissionExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.threadsNamed((String)(this.getClass().getSimpleName() + "-%s"))));
    private final ScheduledExecutorService overallStatusPrintExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledExecutorService runningSplitsPrintExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledExecutorService wakeupExecutor = Executors.newScheduledThreadPool(32);
    private final TaskExecutor taskExecutor;
    private final MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);

    public static void main(String[] args) throws Exception {
        try (TaskExecutorSimulator simulator = new TaskExecutorSimulator();){
            simulator.run();
        }
    }

    private TaskExecutorSimulator() {
        this.taskExecutor = new TaskExecutor(36, 72, 3, 8, this.splitQueue, Ticker.systemTicker());
        this.taskExecutor.start();
    }

    @Override
    public void close() {
        this.submissionExecutor.shutdownNow();
        this.overallStatusPrintExecutor.shutdownNow();
        this.runningSplitsPrintExecutor.shutdownNow();
        this.wakeupExecutor.shutdownNow();
        this.taskExecutor.stop();
    }

    public void run() throws Exception {
        long start = System.nanoTime();
        this.scheduleStatusPrinter(start);
        SimulationController controller = new SimulationController(this.taskExecutor, TaskExecutorSimulator::printSummaryStats);
        this.runExperimentWithinLevelFairness(controller);
        System.out.println("Stopped scheduling new tasks. Ending simulation..");
        controller.stop();
        this.close();
        TimeUnit.SECONDS.sleep(5L);
        System.out.println();
        System.out.println("Simulation finished at " + DateTime.now() + ". Runtime: " + Duration.nanosSince((long)start));
        System.out.println();
        TaskExecutorSimulator.printSummaryStats(controller, this.taskExecutor);
    }

    private void runExperimentOverloadedCluster(SimulationController controller) throws InterruptedException {
        System.out.println("Overload experiment started.");
        SimulationController.TaskSpecification leafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.LEAF, "leaf", OptionalInt.empty(), 16, 30, new SplitGenerators.AggregatedLeafSplitGenerator());
        controller.addTaskSpecification(leafSpec);
        SimulationController.TaskSpecification slowLeafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.LEAF, "slow_leaf", OptionalInt.empty(), 16, 10, new SplitGenerators.SlowLeafSplitGenerator());
        controller.addTaskSpecification(slowLeafSpec);
        SimulationController.TaskSpecification intermediateSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.INTERMEDIATE, "intermediate", OptionalInt.empty(), 8, 40, new SplitGenerators.IntermediateSplitGenerator(this.wakeupExecutor));
        controller.addTaskSpecification(intermediateSpec);
        controller.enableSpecification(leafSpec);
        controller.enableSpecification(slowLeafSpec);
        controller.enableSpecification(intermediateSpec);
        controller.run();
        TimeUnit.SECONDS.sleep(30L);
        for (int i = 0; i < 20; ++i) {
            controller.clearPendingQueue();
            TimeUnit.MINUTES.sleep(1L);
        }
        System.out.println("Overload experiment completed.");
    }

    private void runExperimentStarveSlowSplits(SimulationController controller) throws InterruptedException {
        System.out.println("Starvation experiment started.");
        SimulationController.TaskSpecification slowLeafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.LEAF, "slow_leaf", OptionalInt.of(600), 40, 4, new SplitGenerators.SlowLeafSplitGenerator());
        controller.addTaskSpecification(slowLeafSpec);
        SimulationController.TaskSpecification intermediateSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.INTERMEDIATE, "intermediate", OptionalInt.of(400), 40, 8, new SplitGenerators.IntermediateSplitGenerator(this.wakeupExecutor));
        controller.addTaskSpecification(intermediateSpec);
        SimulationController.TaskSpecification fastLeafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.LEAF, "fast_leaf", OptionalInt.of(600), 40, 4, new SplitGenerators.FastLeafSplitGenerator());
        controller.addTaskSpecification(fastLeafSpec);
        controller.enableSpecification(slowLeafSpec);
        controller.enableSpecification(fastLeafSpec);
        controller.enableSpecification(intermediateSpec);
        controller.run();
        for (int i = 0; i < 60; ++i) {
            TimeUnit.SECONDS.sleep(20L);
            controller.clearPendingQueue();
        }
        System.out.println("Starvation experiment completed.");
    }

    private void runExperimentMisbehavingQuanta(SimulationController controller) throws InterruptedException {
        System.out.println("Misbehaving quanta experiment started.");
        SimulationController.TaskSpecification slowLeafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.LEAF, "good_leaf", OptionalInt.empty(), 16, 4, new SplitGenerators.L4LeafSplitGenerator());
        controller.addTaskSpecification(slowLeafSpec);
        SimulationController.TaskSpecification misbehavingLeafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.LEAF, "bad_leaf", OptionalInt.empty(), 16, 4, new SplitGenerators.QuantaExceedingSplitGenerator());
        controller.addTaskSpecification(misbehavingLeafSpec);
        controller.enableSpecification(slowLeafSpec);
        controller.enableSpecification(misbehavingLeafSpec);
        controller.run();
        for (int i = 0; i < 120; ++i) {
            controller.clearPendingQueue();
            TimeUnit.SECONDS.sleep(20L);
        }
        System.out.println("Misbehaving quanta experiment completed.");
    }

    private void runExperimentWithinLevelFairness(SimulationController controller) throws InterruptedException {
        System.out.println("Level fairness experiment started.");
        SimulationController.TaskSpecification longLeafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.INTERMEDIATE, "l4_long", OptionalInt.empty(), 2, 16, new SplitGenerators.SimpleLeafSplitGenerator(TimeUnit.MINUTES.toNanos(4L), TimeUnit.SECONDS.toNanos(1L)));
        controller.addTaskSpecification(longLeafSpec);
        SimulationController.TaskSpecification shortLeafSpec = new SimulationController.TaskSpecification(SimulationController.TaskSpecification.Type.INTERMEDIATE, "l4_short", OptionalInt.empty(), 2, 16, new SplitGenerators.SimpleLeafSplitGenerator(TimeUnit.MINUTES.toNanos(2L), TimeUnit.SECONDS.toNanos(1L)));
        controller.addTaskSpecification(shortLeafSpec);
        controller.enableSpecification(longLeafSpec);
        controller.run();
        TimeUnit.MINUTES.sleep(1L);
        controller.runCallback();
        controller.enableSpecification(shortLeafSpec);
        TimeUnit.SECONDS.sleep(25L);
        controller.runCallback();
        TimeUnit.MINUTES.sleep(2L);
        System.out.println("Level fairness experiment completed.");
    }

    private void scheduleStatusPrinter(long start) {
        this.overallStatusPrintExecutor.scheduleAtFixedRate(() -> {
            try {
                System.out.printf("%6s -- %4s splits (R: %2s  L: %3s  I: %3s  B: %3s  W: %3s  C: %5s)  |  %3s tasks (%3s %3s %3s %3s %3s)  |  Selections: %4s %4s %4s %4s %3s\n", Duration.nanosSince((long)start), this.taskExecutor.getTotalSplits(), this.taskExecutor.getRunningSplits(), this.taskExecutor.getTotalSplits() - this.taskExecutor.getIntermediateSplits(), this.taskExecutor.getIntermediateSplits(), this.taskExecutor.getBlockedSplits(), this.taskExecutor.getWaitingSplits(), this.taskExecutor.getCompletedSplitsLevel0() + this.taskExecutor.getCompletedSplitsLevel1() + this.taskExecutor.getCompletedSplitsLevel2() + this.taskExecutor.getCompletedSplitsLevel3() + this.taskExecutor.getCompletedSplitsLevel4(), this.taskExecutor.getTasks(), this.taskExecutor.getRunningTasksLevel0(), this.taskExecutor.getRunningTasksLevel1(), this.taskExecutor.getRunningTasksLevel2(), this.taskExecutor.getRunningTasksLevel3(), this.taskExecutor.getRunningTasksLevel4(), (int)this.splitQueue.getSelectedCountLevel0().getOneMinute().getRate(), (int)this.splitQueue.getSelectedCountLevel1().getOneMinute().getRate(), (int)this.splitQueue.getSelectedCountLevel2().getOneMinute().getRate(), (int)this.splitQueue.getSelectedCountLevel3().getOneMinute().getRate(), (int)this.splitQueue.getSelectedCountLevel4().getOneMinute().getRate());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private static void printSummaryStats(SimulationController controller, TaskExecutor taskExecutor) {
        Map<SimulationController.TaskSpecification, Boolean> specEnabled = controller.getSpecificationEnabled();
        ListMultimap<SimulationController.TaskSpecification, SimulationTask> completedTasks = controller.getCompletedTasks();
        ListMultimap<SimulationController.TaskSpecification, SimulationTask> runningTasks = controller.getRunningTasks();
        ImmutableSet allTasks = ImmutableSet.builder().addAll((Iterable)completedTasks.values()).addAll((Iterable)runningTasks.values()).build();
        long completedSplits = completedTasks.values().stream().mapToInt(t -> t.getCompletedSplits().size()).sum();
        long runningSplits = runningTasks.values().stream().mapToInt(t -> t.getCompletedSplits().size()).sum();
        System.out.println("Completed tasks : " + completedTasks.size());
        System.out.println("Remaining tasks : " + runningTasks.size());
        System.out.println("Completed splits: " + completedSplits);
        System.out.println("Remaining splits: " + runningSplits);
        System.out.println();
        System.out.println("Completed tasks  L0: " + taskExecutor.getCompletedTasksLevel0());
        System.out.println("Completed tasks  L1: " + taskExecutor.getCompletedTasksLevel1());
        System.out.println("Completed tasks  L2: " + taskExecutor.getCompletedTasksLevel2());
        System.out.println("Completed tasks  L3: " + taskExecutor.getCompletedTasksLevel3());
        System.out.println("Completed tasks  L4: " + taskExecutor.getCompletedTasksLevel4());
        System.out.println();
        System.out.println("Completed splits L0: " + taskExecutor.getCompletedSplitsLevel0());
        System.out.println("Completed splits L1: " + taskExecutor.getCompletedSplitsLevel1());
        System.out.println("Completed splits L2: " + taskExecutor.getCompletedSplitsLevel2());
        System.out.println("Completed splits L3: " + taskExecutor.getCompletedSplitsLevel3());
        System.out.println("Completed splits L4: " + taskExecutor.getCompletedSplitsLevel4());
        Histogram<Long> levelsHistogram = Histogram.fromContinuous(ImmutableList.of((Object)TimeUnit.MILLISECONDS.toNanos(0L), (Object)TimeUnit.MILLISECONDS.toNanos(1000L), (Object)TimeUnit.MILLISECONDS.toNanos(10000L), (Object)TimeUnit.MILLISECONDS.toNanos(60000L), (Object)TimeUnit.MILLISECONDS.toNanos(300000L), (Object)TimeUnit.HOURS.toNanos(1L), (Object)TimeUnit.DAYS.toNanos(1L)));
        System.out.println();
        System.out.println("Levels - Completed Task Processed Time");
        levelsHistogram.printDistribution(completedTasks.values().stream().filter(t -> t.getSpecification().getType() == SimulationController.TaskSpecification.Type.LEAF).collect(Collectors.toList()), SimulationTask::getScheduledTimeNanos, SimulationTask::getProcessedTimeNanos, Duration::succinctNanos, TaskExecutorSimulator::formatNanos);
        System.out.println();
        System.out.println("Levels - Running Task Processed Time");
        levelsHistogram.printDistribution(runningTasks.values().stream().filter(t -> t.getSpecification().getType() == SimulationController.TaskSpecification.Type.LEAF).collect(Collectors.toList()), SimulationTask::getScheduledTimeNanos, SimulationTask::getProcessedTimeNanos, Duration::succinctNanos, TaskExecutorSimulator::formatNanos);
        System.out.println();
        System.out.println("Levels - All Task Wait Time");
        levelsHistogram.printDistribution(runningTasks.values().stream().filter(t -> t.getSpecification().getType() == SimulationController.TaskSpecification.Type.LEAF).collect(Collectors.toList()), SimulationTask::getScheduledTimeNanos, SimulationTask::getTotalWaitTimeNanos, Duration::succinctNanos, TaskExecutorSimulator::formatNanos);
        System.out.println();
        System.out.println("Specification - Processed time");
        Set specifications = runningTasks.values().stream().map(t -> t.getSpecification().getName()).collect(Collectors.toSet());
        Histogram.fromDiscrete(specifications).printDistribution(allTasks, t -> t.getSpecification().getName(), SimulationTask::getProcessedTimeNanos, Function.identity(), TaskExecutorSimulator::formatNanos);
        System.out.println();
        System.out.println("Specification - Wait time");
        Histogram.fromDiscrete(specifications).printDistribution(allTasks, t -> t.getSpecification().getName(), SimulationTask::getTotalWaitTimeNanos, Function.identity(), TaskExecutorSimulator::formatNanos);
        System.out.println();
        System.out.println("Breakdown by specification");
        System.out.println("##########################");
        for (SimulationController.TaskSpecification specification : specEnabled.keySet()) {
            ImmutableList allSpecificationTasks = ImmutableList.builder().addAll((Iterable)completedTasks.get((Object)specification)).addAll((Iterable)runningTasks.get((Object)specification)).build();
            System.out.println(specification.getName());
            System.out.println("=============================");
            System.out.println("Completed tasks           : " + completedTasks.get((Object)specification).size());
            System.out.println("In-progress tasks         : " + runningTasks.get((Object)specification).size());
            System.out.println("Total tasks               : " + specification.getTotalTasks());
            System.out.println("Splits/task               : " + specification.getNumSplitsPerTask());
            System.out.println("Current required time     : " + Duration.succinctNanos((long)allSpecificationTasks.stream().mapToLong(SimulationTask::getScheduledTimeNanos).sum()));
            System.out.println("Completed scheduled time  : " + Duration.succinctNanos((long)allSpecificationTasks.stream().mapToLong(SimulationTask::getProcessedTimeNanos).sum()));
            System.out.println("Total wait time           : " + Duration.succinctNanos((long)allSpecificationTasks.stream().mapToLong(SimulationTask::getTotalWaitTimeNanos).sum()));
            System.out.println();
            System.out.println("All Tasks by Scheduled time - Processed Time");
            levelsHistogram.printDistribution(allSpecificationTasks, SimulationTask::getScheduledTimeNanos, SimulationTask::getProcessedTimeNanos, Duration::succinctNanos, TaskExecutorSimulator::formatNanos);
            System.out.println();
            System.out.println("All Tasks by Scheduled time - Wait Time");
            levelsHistogram.printDistribution(allSpecificationTasks, SimulationTask::getScheduledTimeNanos, SimulationTask::getTotalWaitTimeNanos, Duration::succinctNanos, TaskExecutorSimulator::formatNanos);
            System.out.println();
            System.out.println("Complete Tasks by Scheduled time - Wait Time");
            levelsHistogram.printDistribution(completedTasks.get((Object)specification), SimulationTask::getScheduledTimeNanos, SimulationTask::getTotalWaitTimeNanos, Duration::succinctNanos, TaskExecutorSimulator::formatNanos);
        }
    }

    private static String formatNanos(List<Long> list) {
        LongSummaryStatistics stats = list.stream().mapToLong(Long::new).summaryStatistics();
        return String.format("Min: %8s  Max: %8s  Avg: %8s  Sum: %8s", Duration.succinctNanos((long)(stats.getMin() == Long.MAX_VALUE ? 0L : stats.getMin())), Duration.succinctNanos((long)(stats.getMax() == Long.MIN_VALUE ? 0L : stats.getMax())), Duration.succinctNanos((long)((long)stats.getAverage())), Duration.succinctNanos((long)stats.getSum()));
    }
}

