/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.executor.MultilevelSplitQueue;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.execution.executor.TaskHandle;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.testing.Assertions;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTaskExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(invocationCount=100)
    public void testTasksComplete() throws Exception {
        TestingTicker ticker = new TestingTicker();
        TaskExecutor taskExecutor = new TaskExecutor(4, 8, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        ticker.increment(20L, TimeUnit.MILLISECONDS);
        try {
            TaskId taskId = new TaskId("test", 0, 0);
            TaskHandle taskHandle = taskExecutor.addTask(taskId, () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS));
            Phaser beginPhase = new Phaser();
            beginPhase.register();
            Phaser verificationComplete = new Phaser();
            verificationComplete.register();
            TestingJob driver1 = new TestingJob(ticker, new Phaser(1), beginPhase, verificationComplete, 10, 0);
            ListenableFuture future1 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits(taskHandle, true, (List)ImmutableList.of((Object)driver1)));
            TestingJob driver2 = new TestingJob(ticker, new Phaser(1), beginPhase, verificationComplete, 10, 0);
            ListenableFuture future2 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits(taskHandle, true, (List)ImmutableList.of((Object)driver2)));
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)0);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)0);
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)0);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)0);
            ticker.increment(10L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)taskExecutor.getMaxActiveSplitTime(), (long)10L);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)1);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)1);
            verificationComplete.arriveAndAwaitAdvance();
            TestingJob driver3 = new TestingJob(ticker, new Phaser(1), beginPhase, verificationComplete, 10, 0);
            ListenableFuture future3 = (ListenableFuture)Iterables.getOnlyElement((Iterable)taskExecutor.enqueueSplits(taskHandle, false, (List)ImmutableList.of((Object)driver3)));
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)2);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)2);
            Assert.assertEquals((int)driver3.getCompletedPhases(), (int)0);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            for (int i = 0; i < 7; ++i) {
                verificationComplete.arriveAndAwaitAdvance();
                beginPhase.arriveAndAwaitAdvance();
                Assert.assertEquals((int)beginPhase.getPhase(), (int)(verificationComplete.getPhase() + 1));
            }
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver3.getCompletedPhases(), (int)8);
            future1.get(1L, TimeUnit.SECONDS);
            future2.get(1L, TimeUnit.SECONDS);
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            verificationComplete.arriveAndAwaitAdvance();
            beginPhase.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver2.getCompletedPhases(), (int)10);
            Assert.assertEquals((int)driver3.getCompletedPhases(), (int)10);
            future3.get(1L, TimeUnit.SECONDS);
            verificationComplete.arriveAndAwaitAdvance();
            Assert.assertEquals((int)driver1.getFirstPhase(), (int)0);
            Assert.assertEquals((int)driver2.getFirstPhase(), (int)0);
            Assert.assertEquals((int)driver3.getFirstPhase(), (int)2);
            Assert.assertEquals((int)driver1.getLastPhase(), (int)10);
            Assert.assertEquals((int)driver2.getLastPhase(), (int)10);
            Assert.assertEquals((int)driver3.getLastPhase(), (int)12);
            ticker.increment(30L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)taskExecutor.getMaxActiveSplitTime(), (long)0L);
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(invocationCount=100)
    public void testQuantaFairness() {
        TestingTicker ticker = new TestingTicker();
        TaskExecutor taskExecutor = new TaskExecutor(1, 2, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        ticker.increment(20L, TimeUnit.MILLISECONDS);
        try {
            TaskHandle shortQuantaTaskHandle = taskExecutor.addTask(new TaskId("shortQuanta", 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS));
            TaskHandle longQuantaTaskHandle = taskExecutor.addTask(new TaskId("longQuanta", 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS));
            Phaser globalPhaser = new Phaser();
            TestingJob shortQuantaDriver = new TestingJob(ticker, new Phaser(), new Phaser(), globalPhaser, 10, 10);
            TestingJob longQuantaDriver = new TestingJob(ticker, new Phaser(), new Phaser(), globalPhaser, 10, 20);
            taskExecutor.enqueueSplits(shortQuantaTaskHandle, true, (List)ImmutableList.of((Object)shortQuantaDriver));
            taskExecutor.enqueueSplits(longQuantaTaskHandle, true, (List)ImmutableList.of((Object)longQuantaDriver));
            for (int i = 0; i < 11; ++i) {
                globalPhaser.arriveAndAwaitAdvance();
            }
            Assert.assertTrue((shortQuantaDriver.getCompletedPhases() >= 7 && shortQuantaDriver.getCompletedPhases() <= 8 ? 1 : 0) != 0);
            Assert.assertTrue((longQuantaDriver.getCompletedPhases() >= 3 && longQuantaDriver.getCompletedPhases() <= 4 ? 1 : 0) != 0);
            globalPhaser.arriveAndDeregister();
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(invocationCount=100)
    public void testLevelMovement() {
        TestingTicker ticker = new TestingTicker();
        TaskExecutor taskExecutor = new TaskExecutor(2, 2, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        ticker.increment(20L, TimeUnit.MILLISECONDS);
        try {
            TaskHandle testTaskHandle = taskExecutor.addTask(new TaskId("test", 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS));
            Phaser globalPhaser = new Phaser();
            globalPhaser.bulkRegister(3);
            int quantaTimeMills = 500;
            int phasesPerSecond = 1000 / quantaTimeMills;
            int totalPhases = MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1] * phasesPerSecond;
            TestingJob driver1 = new TestingJob(ticker, globalPhaser, new Phaser(), new Phaser(), totalPhases, quantaTimeMills);
            TestingJob driver2 = new TestingJob(ticker, globalPhaser, new Phaser(), new Phaser(), totalPhases, quantaTimeMills);
            taskExecutor.enqueueSplits(testTaskHandle, true, (List)ImmutableList.of((Object)driver1, (Object)driver2));
            int completedPhases = 0;
            for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
                while (completedPhases / phasesPerSecond < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1]) {
                    globalPhaser.arriveAndAwaitAdvance();
                    ++completedPhases;
                }
                Assert.assertEquals((int)testTaskHandle.getPriority().getLevel(), (int)(i + 1));
            }
            globalPhaser.arriveAndDeregister();
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(invocationCount=100)
    public void testLevelMultipliers() throws Exception {
        TestingTicker ticker = new TestingTicker();
        TaskExecutor taskExecutor = new TaskExecutor(1, 3, 3, 4, new MultilevelSplitQueue(2.0), (Ticker)ticker);
        taskExecutor.start();
        ticker.increment(20L, TimeUnit.MILLISECONDS);
        try {
            for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
                TaskHandle[] taskHandles = new TaskHandle[]{taskExecutor.addTask(new TaskId("test1", 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS)), taskExecutor.addTask(new TaskId("test2", 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS)), taskExecutor.addTask(new TaskId("test3", 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS))};
                TestingJob task0Job = new TestingJob(ticker, new Phaser(1), new Phaser(), new Phaser(), 1, MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] * 1000);
                taskExecutor.enqueueSplits(taskHandles[0], true, (List)ImmutableList.of((Object)task0Job));
                TestingJob task1Job = new TestingJob(ticker, new Phaser(1), new Phaser(), new Phaser(), 1, MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i] * 1000);
                taskExecutor.enqueueSplits(taskHandles[1], true, (List)ImmutableList.of((Object)task1Job));
                TestingJob task2Job = new TestingJob(ticker, new Phaser(1), new Phaser(), new Phaser(), 1, MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i] * 1000);
                taskExecutor.enqueueSplits(taskHandles[2], true, (List)ImmutableList.of((Object)task2Job));
                task0Job.getCompletedFuture().get();
                task1Job.getCompletedFuture().get();
                task2Job.getCompletedFuture().get();
                Phaser globalPhaser = new Phaser(2);
                int phasesForNextLevel = MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] - MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i];
                TestingJob[] drivers = new TestingJob[6];
                for (int j = 0; j < 6; ++j) {
                    drivers[j] = new TestingJob(ticker, globalPhaser, new Phaser(), new Phaser(), phasesForNextLevel, 1000);
                }
                taskExecutor.enqueueSplits(taskHandles[0], true, (List)ImmutableList.of((Object)drivers[0], (Object)drivers[1]));
                taskExecutor.enqueueSplits(taskHandles[1], true, (List)ImmutableList.of((Object)drivers[2], (Object)drivers[3]));
                taskExecutor.enqueueSplits(taskHandles[2], true, (List)ImmutableList.of((Object)drivers[4], (Object)drivers[5]));
                int lowerLevelStart = drivers[2].getCompletedPhases() + drivers[3].getCompletedPhases() + drivers[4].getCompletedPhases() + drivers[5].getCompletedPhases();
                int higherLevelStart = drivers[0].getCompletedPhases() + drivers[1].getCompletedPhases();
                while (Arrays.stream(drivers).noneMatch(TestingJob::isFinished)) {
                    globalPhaser.arriveAndAwaitAdvance();
                    int lowerLevelEnd = drivers[2].getCompletedPhases() + drivers[3].getCompletedPhases() + drivers[4].getCompletedPhases() + drivers[5].getCompletedPhases();
                    int lowerLevelTime = lowerLevelEnd - lowerLevelStart;
                    int higherLevelEnd = drivers[0].getCompletedPhases() + drivers[1].getCompletedPhases();
                    int higherLevelTime = higherLevelEnd - higherLevelStart;
                    if (higherLevelTime <= 20) continue;
                    Assertions.assertGreaterThan((Comparable)Integer.valueOf(lowerLevelTime), (Comparable)Integer.valueOf(higherLevelTime * 2 - 10));
                    Assertions.assertLessThan((Comparable)Integer.valueOf(higherLevelTime), (Comparable)Integer.valueOf(lowerLevelTime * 2 + 10));
                }
                try {
                    globalPhaser.arriveAndDeregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                taskExecutor.removeTask(taskHandles[0]);
                taskExecutor.removeTask(taskHandles[1]);
                taskExecutor.removeTask(taskHandles[2]);
            }
        }
        finally {
            taskExecutor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskHandle() {
        TestingTicker ticker = new TestingTicker();
        TaskExecutor taskExecutor = new TaskExecutor(4, 8, 3, 4, (Ticker)ticker);
        taskExecutor.start();
        try {
            TaskId taskId = new TaskId("test", 0, 0);
            TaskHandle taskHandle = taskExecutor.addTask(taskId, () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS));
            Phaser beginPhase = new Phaser();
            beginPhase.register();
            Phaser verificationComplete = new Phaser();
            verificationComplete.register();
            TestingJob driver1 = new TestingJob(ticker, new Phaser(), beginPhase, verificationComplete, 10, 0);
            TestingJob driver2 = new TestingJob(ticker, new Phaser(), beginPhase, verificationComplete, 10, 0);
            taskExecutor.enqueueSplits(taskHandle, true, (List)ImmutableList.of((Object)driver1));
            Assert.assertEquals((int)taskHandle.getRunningLeafSplits(), (int)0);
            taskExecutor.enqueueSplits(taskHandle, false, (List)ImmutableList.of((Object)driver2));
            Assert.assertEquals((int)taskHandle.getRunningLeafSplits(), (int)1);
            beginPhase.arriveAndDeregister();
            verificationComplete.arriveAndDeregister();
        }
        finally {
            taskExecutor.stop();
        }
    }

    @Test
    public void testLevelContributionCap() {
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TaskHandle handle0 = new TaskHandle(new TaskId("test0", 0, 0), splitQueue, () -> 1.0, 1, new Duration(1.0, TimeUnit.SECONDS));
        TaskHandle handle1 = new TaskHandle(new TaskId("test1", 0, 0), splitQueue, () -> 1.0, 1, new Duration(1.0, TimeUnit.SECONDS));
        for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
            long levelAdvanceTime = TimeUnit.SECONDS.toNanos(MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] - MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i]);
            handle0.addScheduledNanos(levelAdvanceTime);
            Assert.assertEquals((int)handle0.getPriority().getLevel(), (int)(i + 1));
            handle1.addScheduledNanos(levelAdvanceTime);
            Assert.assertEquals((int)handle1.getPriority().getLevel(), (int)(i + 1));
            Assert.assertEquals((long)splitQueue.getLevelScheduledTime(i), (long)(2L * Math.min(levelAdvanceTime, MultilevelSplitQueue.LEVEL_CONTRIBUTION_CAP)));
            Assert.assertEquals((long)splitQueue.getLevelScheduledTime(i + 1), (long)0L);
        }
    }

    @Test
    public void testUpdateLevelWithCap() {
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TaskHandle handle0 = new TaskHandle(new TaskId("test0", 0, 0), splitQueue, () -> 1.0, 1, new Duration(1.0, TimeUnit.SECONDS));
        long quantaNanos = TimeUnit.MINUTES.toNanos(10L);
        handle0.addScheduledNanos(quantaNanos);
        long cappedNanos = Math.min(quantaNanos, MultilevelSplitQueue.LEVEL_CONTRIBUTION_CAP);
        for (int i = 0; i < MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS.length - 1; ++i) {
            long thisLevelTime = Math.min(TimeUnit.SECONDS.toNanos(MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i + 1] - MultilevelSplitQueue.LEVEL_THRESHOLD_SECONDS[i]), cappedNanos);
            Assert.assertEquals((long)splitQueue.getLevelScheduledTime(i), (long)thisLevelTime);
            cappedNanos -= thisLevelTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testMinMaxDriversPerTask() {
        int maxDriversPerTask = 2;
        MultilevelSplitQueue splitQueue = new MultilevelSplitQueue(2.0);
        TestingTicker ticker = new TestingTicker();
        TaskExecutor taskExecutor = new TaskExecutor(4, 16, 1, maxDriversPerTask, splitQueue, (Ticker)ticker);
        taskExecutor.start();
        try {
            int batch;
            TaskHandle testTaskHandle = taskExecutor.addTask(new TaskId("test", 0, 0), () -> 0.0, 10, new Duration(1.0, TimeUnit.MILLISECONDS));
            int batchCount = 4;
            TestingJob[] splits = new TestingJob[8];
            Phaser[] phasers = new Phaser[batchCount];
            for (batch = 0; batch < batchCount; ++batch) {
                phasers[batch] = new Phaser();
                phasers[batch].register();
                TestingJob split1 = new TestingJob(ticker, new Phaser(), new Phaser(), phasers[batch], maxDriversPerTask, 0);
                TestingJob split2 = new TestingJob(ticker, new Phaser(), new Phaser(), phasers[batch], maxDriversPerTask, 0);
                splits[2 * batch] = split1;
                splits[2 * batch + 1] = split2;
                taskExecutor.enqueueSplits(testTaskHandle, false, (List)ImmutableList.of((Object)split1, (Object)split2));
            }
            for (batch = 0; batch < batchCount; ++batch) {
                TestTaskExecutor.waitUntilSplitsStart((List<TestingJob>)ImmutableList.of((Object)splits[2 * batch], (Object)splits[2 * batch + 1]));
                this.assertSplitStates(2 * batch + 1, splits);
                phasers[batch].arriveAndDeregister();
            }
        }
        finally {
            taskExecutor.stop();
        }
    }

    private void assertSplitStates(int endIndex, TestingJob[] splits) {
        int i;
        for (i = 0; i <= endIndex; ++i) {
            Assert.assertTrue((boolean)splits[i].isStarted());
        }
        for (i = endIndex + 1; i < splits.length; ++i) {
            Assert.assertFalse((boolean)splits[i].isStarted());
        }
    }

    private static void waitUntilSplitsStart(List<TestingJob> splits) {
        while (splits.stream().anyMatch(split -> !split.isStarted())) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private static class TestingJob
    implements SplitRunner {
        private final TestingTicker ticker;
        private final Phaser globalPhaser;
        private final Phaser beginQuantaPhaser;
        private final Phaser endQuantaPhaser;
        private final int requiredPhases;
        private final int quantaTimeMillis;
        private final AtomicInteger completedPhases = new AtomicInteger();
        private final AtomicInteger firstPhase = new AtomicInteger(-1);
        private final AtomicInteger lastPhase = new AtomicInteger(-1);
        private final AtomicBoolean started = new AtomicBoolean();
        private final SettableFuture<?> completed = SettableFuture.create();

        public TestingJob(TestingTicker ticker, Phaser globalPhaser, Phaser beginQuantaPhaser, Phaser endQuantaPhaser, int requiredPhases, int quantaTimeMillis) {
            this.ticker = ticker;
            this.globalPhaser = globalPhaser;
            this.beginQuantaPhaser = beginQuantaPhaser;
            this.endQuantaPhaser = endQuantaPhaser;
            this.requiredPhases = requiredPhases;
            this.quantaTimeMillis = quantaTimeMillis;
            beginQuantaPhaser.register();
            endQuantaPhaser.register();
            if (globalPhaser.getRegisteredParties() == 0) {
                globalPhaser.register();
            }
        }

        private int getFirstPhase() {
            return this.firstPhase.get();
        }

        private int getLastPhase() {
            return this.lastPhase.get();
        }

        private int getCompletedPhases() {
            return this.completedPhases.get();
        }

        public ListenableFuture<?> processFor(Duration duration) {
            this.started.set(true);
            this.ticker.increment((long)this.quantaTimeMillis, TimeUnit.MILLISECONDS);
            this.globalPhaser.arriveAndAwaitAdvance();
            int phase = this.beginQuantaPhaser.arriveAndAwaitAdvance();
            this.firstPhase.compareAndSet(-1, phase - 1);
            this.lastPhase.set(phase);
            this.endQuantaPhaser.arriveAndAwaitAdvance();
            if (this.completedPhases.incrementAndGet() >= this.requiredPhases) {
                this.endQuantaPhaser.arriveAndDeregister();
                this.beginQuantaPhaser.arriveAndDeregister();
                this.globalPhaser.arriveAndDeregister();
                this.completed.set(null);
            }
            return Futures.immediateFuture(null);
        }

        public String getInfo() {
            return "testing-split";
        }

        public boolean isFinished() {
            return this.completed.isDone();
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public void close() {
        }

        public Future<?> getCompletedFuture() {
            return this.completed;
        }
    }
}

