/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.StochasticPriorityQueue;
import io.airlift.testing.Assertions;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStochasticPriorityQueue {
    @Test
    public void testContainsAndRemove() {
        int i;
        StochasticPriorityQueue queue = new StochasticPriorityQueue();
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)queue.addOrUpdate((Object)("test" + i), (long)(i + 1)));
        }
        for (i = 0; i < 100; i += 2) {
            Assert.assertTrue((boolean)queue.remove((Object)("test" + i)));
        }
        for (i = 1; i < 100; i += 2) {
            Assert.assertTrue((boolean)queue.contains((Object)("test" + i)));
        }
        Assert.assertFalse((boolean)queue.isEmpty());
        Assert.assertEquals((int)queue.size(), (int)50);
        for (i = 1; i < 100; i += 2) {
            Assert.assertTrue((boolean)queue.remove((Object)("test" + i)));
        }
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals((int)queue.size(), (int)0);
    }

    @Test
    public void testPollDistribution() {
        int i;
        int i2;
        StochasticPriorityQueue queue = new StochasticPriorityQueue();
        for (i2 = 0; i2 < 100; ++i2) {
            Assert.assertTrue((boolean)queue.addOrUpdate((Object)("foo" + i2), 1L));
        }
        for (i2 = 0; i2 < 100; ++i2) {
            Assert.assertTrue((boolean)queue.addOrUpdate((Object)("bar" + i2), 1L));
        }
        int foo = 0;
        for (int i3 = 0; i3 < 1000; ++i3) {
            String value = (String)queue.poll();
            if (value.startsWith("foo")) {
                ++foo;
            }
            Assert.assertTrue((boolean)queue.addOrUpdate((Object)value, 1L));
        }
        BinomialDistribution binomial = new BinomialDistribution(1000, 0.5);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        Assertions.assertLessThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(upperBound));
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(lowerBound));
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)queue.addOrUpdate((Object)("foo" + i), 2L));
        }
        foo = 0;
        for (i = 0; i < 1000; ++i) {
            String value = (String)queue.poll();
            if (value.startsWith("foo")) {
                ++foo;
                Assert.assertTrue((boolean)queue.addOrUpdate((Object)value, 2L));
                continue;
            }
            Assert.assertTrue((boolean)queue.addOrUpdate((Object)value, 1L));
        }
        binomial = new BinomialDistribution(1000, 0.6666666666666666);
        lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        upperBound = binomial.inverseCumulativeProbability(0.999999);
        Assertions.assertLessThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(upperBound));
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(foo), (Comparable)Integer.valueOf(lowerBound));
    }
}

