/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.FifoQueue;
import com.facebook.presto.execution.resourceGroups.IndexedPriorityQueue;
import com.facebook.presto.execution.resourceGroups.StochasticPriorityQueue;
import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.testng.annotations.Test;

public class TestUpdateablePriorityQueue {
    @Test
    public void testFifoQueue() {
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new FifoQueue()), (Collection)ImmutableList.of((Object)1, (Object)2, (Object)3));
    }

    @Test
    public void testIndexedPriorityQueue() {
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue()), (Collection)ImmutableList.of((Object)3, (Object)2, (Object)1));
    }

    @Test
    public void testStochasticPriorityQueue() {
        org.testng.Assert.assertTrue((TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new StochasticPriorityQueue()).size() == 3 ? 1 : 0) != 0);
    }

    private static List<Integer> populateAndExtract(UpdateablePriorityQueue<Integer> queue) {
        queue.addOrUpdate((Object)1, 1L);
        queue.addOrUpdate((Object)2, 2L);
        queue.addOrUpdate((Object)3, 3L);
        return ImmutableList.copyOf(queue);
    }
}

