/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.scheduler.BroadcastOutputBufferManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBroadcastOutputBufferManager {
    @Test
    public void test() {
        AtomicReference outputBufferTarget = new AtomicReference();
        BroadcastOutputBufferManager hashOutputBufferManager = new BroadcastOutputBufferManager(outputBufferTarget::set);
        Assert.assertEquals(outputBufferTarget.get(), (Object)OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.BROADCAST));
        hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(0)), false);
        OutputBuffers expectedOutputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.BROADCAST).withBuffer(new OutputBuffers.OutputBufferId(0), 0);
        Assert.assertEquals(outputBufferTarget.get(), (Object)expectedOutputBuffers);
        hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(1), (Object)new OutputBuffers.OutputBufferId(2)), false);
        expectedOutputBuffers = expectedOutputBuffers.withBuffer(new OutputBuffers.OutputBufferId(1), 0);
        expectedOutputBuffers = expectedOutputBuffers.withBuffer(new OutputBuffers.OutputBufferId(2), 0);
        Assert.assertEquals(outputBufferTarget.get(), (Object)expectedOutputBuffers);
        hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(3)), true);
        expectedOutputBuffers = expectedOutputBuffers.withBuffer(new OutputBuffers.OutputBufferId(3), 0);
        expectedOutputBuffers = expectedOutputBuffers.withNoMoreBufferIds();
        Assert.assertEquals(outputBufferTarget.get(), (Object)expectedOutputBuffers);
        hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(5)), false);
        Assert.assertEquals(outputBufferTarget.get(), (Object)expectedOutputBuffers);
        hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(6)), true);
        Assert.assertEquals(outputBufferTarget.get(), (Object)expectedOutputBuffers);
    }
}

