/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.FixedCountScheduler;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.Node;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestFixedCountScheduler {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stageExecutor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"stageScheduledExecutor-%s"));
    private final MockRemoteTaskFactory taskFactory = new MockRemoteTaskFactory(this.executor, this.scheduledExecutor);

    @AfterClass(alwaysRun=true)
    public void destroyExecutor() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdown();
    }

    @Test
    public void testSingleNode() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition, totalPartitions) -> this.taskFactory.createTableScanTask(new TaskId("test", 1, 1), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.PartitionedSplitCountTracker(delta -> {})), TestFixedCountScheduler.generateRandomNodes(1));
        ScheduleResult result = nodeScheduler.schedule();
        Assert.assertTrue((boolean)result.isFinished());
        Assert.assertTrue((boolean)result.getBlocked().isDone());
        Assert.assertEquals((int)result.getNewTasks().size(), (int)1);
        Assert.assertTrue((boolean)((RemoteTask)result.getNewTasks().iterator().next()).getNodeId().equals("other 0"));
    }

    @Test
    public void testMultipleNodes() {
        FixedCountScheduler nodeScheduler = new FixedCountScheduler((node, partition, totalPartitions) -> this.taskFactory.createTableScanTask(new TaskId("test", 1, 1), node, (List<Split>)ImmutableList.of(), new NodeTaskMap.PartitionedSplitCountTracker(delta -> {})), TestFixedCountScheduler.generateRandomNodes(5));
        ScheduleResult result = nodeScheduler.schedule();
        Assert.assertTrue((boolean)result.isFinished());
        Assert.assertTrue((boolean)result.getBlocked().isDone());
        Assert.assertEquals((int)result.getNewTasks().size(), (int)5);
        Assert.assertEquals((int)((ImmutableSet)result.getNewTasks().stream().map(RemoteTask::getNodeId).collect(ImmutableSet.toImmutableSet())).size(), (int)5);
    }

    private static Map<Integer, Node> generateRandomNodes(int count) {
        ImmutableMap.Builder nodes = ImmutableMap.builder();
        for (int i = 0; i < count; ++i) {
            nodes.put((Object)i, (Object)new PrestoNode("other " + i, URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false));
        }
        return nodes.build();
    }
}

