/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.Session;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.TestingPagesSerdeFactory;
import com.facebook.presto.memory.DefaultQueryContext;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.MemoryPoolListener;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.PageConsumerOperator;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryPools {
    private static final DataSize TEN_MEGABYTES = new DataSize(10.0, DataSize.Unit.MEGABYTE);
    private static final DataSize TEN_MEGABYTES_WITHOUT_TWO_BYTES = new DataSize((double)(TEN_MEGABYTES.toBytes() - 2L), DataSize.Unit.BYTE);
    private static final DataSize ONE_BYTE = new DataSize(1.0, DataSize.Unit.BYTE);
    private QueryId fakeQueryId;
    private LocalQueryRunner localQueryRunner;
    private MemoryPool userPool;
    private List<Driver> drivers;
    private TaskContext taskContext;

    private void setUp(Supplier<List<Driver>> driversSupplier) {
        Preconditions.checkState((this.localQueryRunner == null ? 1 : 0) != 0, (Object)"Already set up");
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setSystemProperty("task_default_concurrency", "1").build();
        this.localQueryRunner = LocalQueryRunner.queryRunnerWithInitialTransaction((Session)session);
        this.localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        this.userPool = new MemoryPool(new MemoryPoolId("test"), TEN_MEGABYTES);
        this.fakeQueryId = new QueryId("fake");
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        DefaultQueryContext queryContext = new DefaultQueryContext(new QueryId("query"), TEN_MEGABYTES, new DataSize(20.0, DataSize.Unit.MEGABYTE), this.userPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.localQueryRunner.getExecutor(), this.localQueryRunner.getScheduler(), TEN_MEGABYTES, spillSpaceTracker);
        this.taskContext = TestingTaskContext.createTaskContext((DefaultQueryContext)queryContext, (Executor)this.localQueryRunner.getExecutor(), (Session)session);
        this.drivers = (List)driversSupplier.get();
    }

    private void setUpCountStarFromOrdersWithJoin() {
        this.setUp((Supplier<List<Driver>>)((Supplier)() -> {
            PageConsumerOperator.PageConsumerOutputFactory outputFactory = new PageConsumerOperator.PageConsumerOutputFactory(types -> page -> {});
            return this.localQueryRunner.createDrivers("SELECT COUNT(*) FROM orders JOIN lineitem ON CAST(orders.orderkey AS VARCHAR) = CAST(lineitem.orderkey AS VARCHAR)", (OutputFactory)outputFactory, this.taskContext);
        }));
    }

    private RevocableMemoryOperator setupConsumeRevocableMemory(DataSize reservedPerPage, long numberOfPages) {
        AtomicReference createOperator = new AtomicReference();
        this.setUp((Supplier<List<Driver>>)((Supplier)() -> {
            DriverContext driverContext = this.taskContext.addPipelineContext(0, false, false).addDriverContext();
            OperatorContext revokableOperatorContext = driverContext.addOperatorContext(Integer.MAX_VALUE, new PlanNodeId("revokable_operator"), TableScanOperator.class.getSimpleName());
            PageConsumerOperator.PageConsumerOutputFactory outputFactory = new PageConsumerOperator.PageConsumerOutputFactory(types -> page -> {});
            Operator outputOperator = outputFactory.createOutputOperator(2, new PlanNodeId("output"), (List)ImmutableList.of(), Function.identity(), (PagesSerdeFactory)new TestingPagesSerdeFactory()).createOperator(driverContext);
            RevocableMemoryOperator revocableMemoryOperator = new RevocableMemoryOperator(revokableOperatorContext, reservedPerPage, numberOfPages);
            createOperator.set(revocableMemoryOperator);
            Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)revocableMemoryOperator, (Operator[])new Operator[]{outputOperator});
            return ImmutableList.of((Object)driver);
        }));
        return (RevocableMemoryOperator)createOperator.get();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.localQueryRunner != null) {
            this.localQueryRunner.close();
            this.localQueryRunner = null;
        }
    }

    @Test
    public void testBlockingOnUserMemory() {
        this.setUpCountStarFromOrdersWithJoin();
        Assert.assertTrue((boolean)this.userPool.tryReserve(this.fakeQueryId, "test", TEN_MEGABYTES.toBytes()));
        this.runDriversUntilBlocked(this.waitingForUserMemory());
        Assert.assertTrue((this.userPool.getFreeBytes() <= 0L ? 1 : 0) != 0, (String)String.format("Expected empty pool but got [%d]", this.userPool.getFreeBytes()));
        this.userPool.free(this.fakeQueryId, "test", TEN_MEGABYTES.toBytes());
        this.assertDriversProgress(this.waitingForUserMemory());
    }

    @Test
    public void testNotifyListenerOnMemoryReserved() {
        this.setupConsumeRevocableMemory(ONE_BYTE, 10L);
        AtomicReference notifiedPool = new AtomicReference();
        AtomicLong notifiedBytes = new AtomicLong();
        this.userPool.addListener(MemoryPoolListener.onMemoryReserved(pool -> {
            notifiedPool.set(pool);
            notifiedBytes.set(pool.getReservedBytes());
        }));
        this.userPool.reserve(this.fakeQueryId, "test", 3L);
        Assert.assertEquals(notifiedPool.get(), (Object)this.userPool);
        Assert.assertEquals((long)notifiedBytes.get(), (long)3L);
    }

    @Test
    public void testMemoryFutureCancellation() {
        this.setUpCountStarFromOrdersWithJoin();
        ListenableFuture future = this.userPool.reserve(this.fakeQueryId, "test", TEN_MEGABYTES.toBytes());
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        try {
            future.cancel(true);
            Assert.fail((String)"cancel should fail");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"cancellation is not supported");
        }
        this.userPool.free(this.fakeQueryId, "test", TEN_MEGABYTES.toBytes());
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void testBlockingOnRevocableMemoryFreeUser() {
        this.setupConsumeRevocableMemory(ONE_BYTE, 10L);
        Assert.assertTrue((boolean)this.userPool.tryReserve(this.fakeQueryId, "test", TEN_MEGABYTES_WITHOUT_TWO_BYTES.toBytes()));
        Assert.assertEquals((long)this.runDriversUntilBlocked(this.waitingForRevocableSystemMemory()), (long)2L);
        Assert.assertTrue((this.userPool.getFreeBytes() <= 0L ? 1 : 0) != 0, (String)String.format("Expected empty pool but got [%d]", this.userPool.getFreeBytes()));
        this.userPool.free(this.fakeQueryId, "test", 5L);
        Assert.assertEquals((long)this.runDriversUntilBlocked(this.waitingForRevocableSystemMemory()), (long)5L);
        Assert.assertTrue((this.userPool.getFreeBytes() <= 0L ? 1 : 0) != 0, (String)String.format("Expected empty pool but got [%d]", this.userPool.getFreeBytes()));
        this.userPool.free(this.fakeQueryId, "test", 3L);
        this.assertDriversProgress(this.waitingForRevocableSystemMemory());
        Assert.assertEquals((long)this.userPool.getFreeBytes(), (long)10L);
    }

    @Test
    public void testBlockingOnRevocableMemoryFreeViaRevoke() {
        RevocableMemoryOperator revocableMemoryOperator = this.setupConsumeRevocableMemory(ONE_BYTE, 5L);
        Assert.assertTrue((boolean)this.userPool.tryReserve(this.fakeQueryId, "test", TEN_MEGABYTES_WITHOUT_TWO_BYTES.toBytes()));
        Assert.assertEquals((long)this.runDriversUntilBlocked(this.waitingForRevocableSystemMemory()), (long)2L);
        revocableMemoryOperator.getOperatorContext().requestMemoryRevoking();
        Assert.assertEquals((long)this.runDriversUntilBlocked(this.waitingForRevocableSystemMemory()), (long)2L);
        revocableMemoryOperator.getOperatorContext().requestMemoryRevoking();
        this.assertDriversProgress(this.waitingForRevocableSystemMemory());
        Assert.assertEquals((long)this.userPool.getFreeBytes(), (long)2L);
    }

    @Test
    public void testTaggedAllocations() {
        QueryId testQuery = new QueryId("test_query");
        MemoryPool testPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1000.0, DataSize.Unit.BYTE));
        testPool.reserve(testQuery, "test_tag", 10L);
        Map allocations = (Map)testPool.getTaggedMemoryAllocations().get(testQuery);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_tag", (Object)10L));
        testPool.free(testQuery, "test_tag", 5L);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_tag", (Object)5L));
        testPool.reserve(testQuery, "test_tag2", 20L);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_tag", (Object)5L, (Object)"test_tag2", (Object)20L));
        testPool.free(testQuery, "test_tag", 5L);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_tag2", (Object)20L));
        testPool.free(testQuery, "test_tag2", 20L);
        Assert.assertEquals((int)testPool.getTaggedMemoryAllocations().size(), (int)0);
    }

    @Test
    public void testMoveQuery() {
        QueryId testQuery = new QueryId("test_query");
        MemoryPool pool1 = new MemoryPool(new MemoryPoolId("test"), new DataSize(1000.0, DataSize.Unit.BYTE));
        MemoryPool pool2 = new MemoryPool(new MemoryPoolId("test"), new DataSize(1000.0, DataSize.Unit.BYTE));
        pool1.reserve(testQuery, "test_tag", 10L);
        Map allocations = (Map)pool1.getTaggedMemoryAllocations().get(testQuery);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_tag", (Object)10L));
        pool1.moveQuery(testQuery, pool2);
        Assert.assertNull(pool1.getTaggedMemoryAllocations().get(testQuery));
        allocations = (Map)pool2.getTaggedMemoryAllocations().get(testQuery);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_tag", (Object)10L));
        Assert.assertEquals((long)pool1.getFreeBytes(), (long)1000L);
        Assert.assertEquals((long)pool2.getFreeBytes(), (long)990L);
        pool2.free(testQuery, "test", 10L);
        Assert.assertEquals((long)pool2.getFreeBytes(), (long)1000L);
    }

    private long runDriversUntilBlocked(Predicate<OperatorContext> reason) {
        long iterationsCount = 0L;
        while (!TestMemoryPools.isOperatorBlocked(this.drivers, reason)) {
            for (Driver driver : this.drivers) {
                driver.process();
            }
            ++iterationsCount;
        }
        for (Driver driver : this.drivers) {
            Assert.assertFalse((boolean)driver.isFinished());
        }
        return iterationsCount;
    }

    private void assertDriversProgress(Predicate<OperatorContext> reason) {
        do {
            Assert.assertFalse((boolean)TestMemoryPools.isOperatorBlocked(this.drivers, reason));
            boolean progress = false;
            for (Driver driver : this.drivers) {
                ListenableFuture blocked = driver.process();
                progress |= blocked.isDone();
            }
            Assert.assertTrue((boolean)progress);
        } while (!this.drivers.stream().allMatch(Driver::isFinished));
    }

    private Predicate<OperatorContext> waitingForUserMemory() {
        return operatorContext -> !operatorContext.isWaitingForMemory().isDone();
    }

    private Predicate<OperatorContext> waitingForRevocableSystemMemory() {
        return operatorContext -> !operatorContext.isWaitingForRevocableMemory().isDone() && !operatorContext.isMemoryRevokingRequested();
    }

    private static boolean isOperatorBlocked(List<Driver> drivers, Predicate<OperatorContext> reason) {
        for (Driver driver : drivers) {
            for (OperatorContext operatorContext : driver.getDriverContext().getOperatorContexts()) {
                if (!reason.apply((Object)operatorContext)) continue;
                return true;
            }
        }
        return false;
    }

    private class RevocableMemoryOperator
    implements Operator {
        private final DataSize reservedPerPage;
        private final long numberOfPages;
        private final OperatorContext operatorContext;
        private long producedPagesCount;
        private final LocalMemoryContext revocableMemoryContext;

        public RevocableMemoryOperator(OperatorContext operatorContext, DataSize reservedPerPage, long numberOfPages) {
            this.operatorContext = operatorContext;
            this.reservedPerPage = reservedPerPage;
            this.numberOfPages = numberOfPages;
            this.revocableMemoryContext = operatorContext.localRevocableMemoryContext();
        }

        public ListenableFuture<?> startMemoryRevoke() {
            return Futures.immediateFuture(null);
        }

        public void finishMemoryRevoke() {
            this.revocableMemoryContext.setBytes(0L);
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public void finish() {
            this.revocableMemoryContext.setBytes(0L);
        }

        public boolean isFinished() {
            return this.producedPagesCount >= this.numberOfPages;
        }

        public boolean needsInput() {
            return false;
        }

        public void addInput(Page page) {
            throw new UnsupportedOperationException();
        }

        public Page getOutput() {
            this.revocableMemoryContext.setBytes(this.revocableMemoryContext.getBytes() + this.reservedPerPage.toBytes());
            ++this.producedPagesCount;
            if (this.producedPagesCount == this.numberOfPages) {
                this.finish();
            }
            return new Page(10, new Block[0]);
        }
    }
}

