/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeMemoryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeMemoryConfig)ConfigAssertions.recordDefaults(NodeMemoryConfig.class)).setLegacySystemPoolEnabled(false).setMaxQueryMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.1, DataSize.Unit.BYTE)).setMaxQueryTotalMemoryPerNode(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE)).setHeapHeadroom(new DataSize((double)NodeMemoryConfig.AVAILABLE_HEAP_MEMORY * 0.3, DataSize.Unit.BYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.max-memory-per-node", (Object)"1GB").put((Object)"query.max-total-memory-per-node", (Object)"3GB").put((Object)"memory.heap-headroom-per-node", (Object)"1GB").put((Object)"deprecated.legacy-system-pool-enabled", (Object)"true").build();
        NodeMemoryConfig expected = new NodeMemoryConfig().setLegacySystemPoolEnabled(true).setMaxQueryMemoryPerNode(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemoryPerNode(new DataSize(3.0, DataSize.Unit.GIGABYTE)).setHeapHeadroom(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidValues() {
        NodeMemoryConfig config = new NodeMemoryConfig();
        config.setMaxQueryTotalMemoryPerNode(new DataSize(1.0, DataSize.Unit.GIGABYTE));
        config.setHeapHeadroom(new DataSize(3.1, DataSize.Unit.GIGABYTE));
        LocalMemoryManager.validateHeapHeadroom((NodeMemoryConfig)config, (long)new DataSize(4.0, DataSize.Unit.GIGABYTE).toBytes());
    }
}

