/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.DefaultQueryContext;
import com.facebook.presto.memory.LegacyQueryContext;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestQueryContext {
    private static final ScheduledExecutorService TEST_EXECUTOR = Executors.newScheduledThreadPool(1, Threads.threadsNamed((String)"test-executor-%s"));

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TEST_EXECUTOR.shutdownNow();
    }

    @DataProvider
    public Object[][] testSetMemoryPoolOptions() {
        return new Object[][]{{false}, {true}};
    }

    @DataProvider
    public Object[][] testMoveTaggedAllocationsOptions() {
        return new Object[][]{{false}, {true}};
    }

    @Test(dataProvider="testSetMemoryPoolOptions")
    public void testSetMemoryPool(boolean useReservedPool) {
        QueryId secondQuery = new QueryId("second");
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, new DataSize(10.0, DataSize.Unit.BYTE));
        long secondQueryMemory = reservedPool.getMaxBytes() - 1L;
        if (useReservedPool) {
            Assert.assertTrue((boolean)reservedPool.reserve(secondQuery, "test", secondQueryMemory).isDone());
        }
        try (LocalQueryRunner localQueryRunner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);){
            DefaultQueryContext queryContext = new DefaultQueryContext(new QueryId("query"), new DataSize(10.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10.0, DataSize.Unit.BYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)localQueryRunner.getExecutor(), localQueryRunner.getScheduler(), new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
            queryContext.getQueryMemoryContext().initializeLocalMemoryContexts("test");
            LocalMemoryContext userMemoryContext = queryContext.getQueryMemoryContext().localUserMemoryContext();
            LocalMemoryContext revocableMemoryContext = queryContext.getQueryMemoryContext().localRevocableMemoryContext();
            Assert.assertTrue((boolean)userMemoryContext.setBytes(3L).isDone());
            Assert.assertTrue((boolean)revocableMemoryContext.setBytes(5L).isDone());
            queryContext.setMemoryPool(reservedPool);
            if (useReservedPool) {
                reservedPool.free(secondQuery, "test", secondQueryMemory);
            }
            userMemoryContext.close();
            revocableMemoryContext.close();
        }
    }

    @Test
    public void testLegacyQueryContext() {
        MemoryPool generalPool = new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        MemoryPool systemPool = new MemoryPool(LocalMemoryManager.SYSTEM_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        try (LocalQueryRunner localQueryRunner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);){
            LegacyQueryContext queryContext = new LegacyQueryContext(new QueryId("query"), new DataSize(10.0, DataSize.Unit.BYTE), generalPool, systemPool, (GcMonitor)new TestingGcMonitor(), (Executor)localQueryRunner.getExecutor(), localQueryRunner.getScheduler(), new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
            TaskStateMachine taskStateMachine = new TaskStateMachine(TaskId.valueOf((String)"task-id"), (Executor)TEST_EXECUTOR);
            TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, SessionTestUtils.TEST_SESSION, false, false, OptionalInt.empty());
            LocalMemoryContext systemContext = taskContext.localSystemMemoryContext();
            ListenableFuture blocked = systemContext.setBytes(10000L);
            Assert.assertTrue((boolean)blocked.isDone());
            Assert.assertEquals((long)systemPool.getReservedBytes(), (long)10000L);
            Assert.assertEquals((long)generalPool.getReservedBytes(), (long)0L);
            systemContext.close();
            Assert.assertEquals((long)systemPool.getReservedBytes(), (long)0L);
            Assert.assertEquals((long)generalPool.getReservedBytes(), (long)0L);
        }
    }

    @Test(dataProvider="testMoveTaggedAllocationsOptions")
    public void testMoveTaggedAllocations(boolean useLegacyQueryContext) {
        MemoryPool generalPool = new MemoryPool(LocalMemoryManager.GENERAL_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        MemoryPool systemPool = new MemoryPool(LocalMemoryManager.SYSTEM_POOL, new DataSize(10000.0, DataSize.Unit.BYTE));
        QueryId queryId = new QueryId("query");
        QueryContext queryContext = TestQueryContext.createQueryContext(useLegacyQueryContext, queryId, generalPool, systemPool);
        TaskStateMachine taskStateMachine = new TaskStateMachine(TaskId.valueOf((String)"task-id"), (Executor)TEST_EXECUTOR);
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, SessionTestUtils.TEST_SESSION, false, false, OptionalInt.empty());
        PipelineContext pipelineContext = taskContext.addPipelineContext(0, false, false);
        DriverContext driverContext = pipelineContext.addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), "test");
        LocalMemoryContext memoryContext = operatorContext.aggregateUserMemoryContext().newLocalMemoryContext("test_context");
        memoryContext.setBytes(1000L);
        Map allocations = (Map)generalPool.getTaggedMemoryAllocations().get(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        queryContext.setMemoryPool(reservedPool);
        Assert.assertNull(generalPool.getTaggedMemoryAllocations().get(queryId));
        allocations = (Map)reservedPool.getTaggedMemoryAllocations().get(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)9000L);
        memoryContext.close();
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)systemPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)10000L);
    }

    private static QueryContext createQueryContext(boolean useLegacyQueryContext, QueryId queryId, MemoryPool generalPool, MemoryPool systemPool) {
        if (useLegacyQueryContext) {
            return new LegacyQueryContext(queryId, new DataSize(10000.0, DataSize.Unit.BYTE), generalPool, systemPool, (GcMonitor)new TestingGcMonitor(), (Executor)TEST_EXECUTOR, TEST_EXECUTOR, new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
        }
        return new DefaultQueryContext(new QueryId("query"), new DataSize(10000.0, DataSize.Unit.BYTE), new DataSize(10000.0, DataSize.Unit.BYTE), generalPool, (GcMonitor)new TestingGcMonitor(), (Executor)TEST_EXECUTOR, TEST_EXECUTOR, new DataSize(0.0, DataSize.Unit.BYTE), new SpillSpaceTracker(new DataSize(0.0, DataSize.Unit.BYTE)));
    }
}

