/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBuilder;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.CustomFunctions;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFunctionRegistry {
    @Test
    public void testIdentityCast() {
        TypeRegistry typeManager = new TypeRegistry();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)typeManager, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeManager, new BlockEncoding[0]), new FeaturesConfig());
        Signature exactOperator = registry.getCoercion((Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((String)exactOperator.getName(), (String)FunctionRegistry.mangleOperatorName((String)OperatorType.CAST.name()));
        Assert.assertEquals((Collection)Lists.transform((List)exactOperator.getArgumentTypes(), (Function)Functions.toStringFunction()), (Collection)ImmutableList.of((Object)"HyperLogLog"));
        Assert.assertEquals((String)exactOperator.getReturnType().getBase(), (String)"HyperLogLog");
    }

    @Test
    public void testExactMatchBeforeCoercion() {
        TypeRegistry typeManager = new TypeRegistry();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)typeManager, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeManager, new BlockEncoding[0]), new FeaturesConfig());
        boolean foundOperator = false;
        for (SqlFunction function : registry.listOperators()) {
            OperatorType operatorType = FunctionRegistry.unmangleOperator((String)function.getSignature().getName());
            if (operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST || !function.getSignature().getTypeVariableConstraints().isEmpty() || function.getSignature().getArgumentTypes().stream().anyMatch(TypeSignature::isCalculated)) continue;
            Signature exactOperator = registry.resolveOperator(operatorType, TypeUtils.resolveTypes((List)function.getSignature().getArgumentTypes(), (TypeManager)typeManager));
            Assert.assertEquals((Object)exactOperator, (Object)function.getSignature());
            foundOperator = true;
        }
        Assert.assertTrue((boolean)foundOperator);
    }

    @Test
    public void testMagicLiteralFunction() {
        Signature signature = FunctionRegistry.getMagicLiteralFunctionSignature((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        Assert.assertEquals((String)signature.getName(), (String)"$literal$timestamp with time zone");
        Assert.assertEquals((Collection)signature.getArgumentTypes(), (Collection)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"bigint")));
        Assert.assertEquals((String)signature.getReturnType().getBase(), (String)"timestamp with time zone");
        TypeRegistry typeManager = new TypeRegistry();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)typeManager, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeManager, new BlockEncoding[0]), new FeaturesConfig());
        Signature function = registry.resolveFunction(QualifiedName.of((String)signature.getName()), TypeSignatureProvider.fromTypeSignatures((List)signature.getArgumentTypes()));
        Assert.assertEquals((Collection)function.getArgumentTypes(), (Collection)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"bigint")));
        Assert.assertEquals((String)signature.getReturnType().getBase(), (String)"timestamp with time zone");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="\\QFunction already registered: custom_add(bigint,bigint):bigint\\E")
    public void testDuplicateFunctions() {
        List functions = (List)new FunctionListBuilder().scalars(CustomFunctions.class).getFunctions().stream().filter(input -> input.getSignature().getName().equals("custom_add")).collect(ImmutableList.toImmutableList());
        TypeRegistry typeManager = new TypeRegistry();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)typeManager, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeManager, new BlockEncoding[0]), new FeaturesConfig());
        registry.addFunctions(functions);
        registry.addFunctions(functions);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="'sum' is both an aggregation and a scalar function")
    public void testConflictingScalarAggregation() {
        List functions = new FunctionListBuilder().scalars(ScalarSum.class).getFunctions();
        TypeRegistry typeManager = new TypeRegistry();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)typeManager, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeManager, new BlockEncoding[0]), new FeaturesConfig());
        registry.addFunctions(functions);
    }

    @Test
    public void testListingHiddenFunctions() {
        TypeRegistry typeManager = new TypeRegistry();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)typeManager, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeManager, new BlockEncoding[0]), new FeaturesConfig());
        List functions = registry.list();
        List names = Lists.transform((List)functions, input -> input.getSignature().getName());
        Assert.assertTrue((boolean)names.contains("length"), (String)("Expected function names " + names + " to contain 'length'"));
        Assert.assertTrue((boolean)names.contains("stddev"), (String)("Expected function names " + names + " to contain 'stddev'"));
        Assert.assertTrue((boolean)names.contains("rank"), (String)("Expected function names " + names + " to contain 'rank'"));
        Assert.assertFalse((boolean)names.contains("like"), (String)("Expected function names " + names + " not to contain 'like'"));
        Assert.assertFalse((boolean)names.contains("$internal$sum_data_size_for_stats"), (String)("Expected function names " + names + " not to contain '$internal$sum_data_size_for_stats'"));
        Assert.assertFalse((boolean)names.contains("$internal$max_data_size_for_stats"), (String)("Expected function names " + names + " not to contain '$internal$max_data_size_for_stats'"));
    }

    @Test
    public void testResolveFunctionByExactMatch() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint")).forParameters("bigint", "bigint").returns(this.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveTypeParametrizedFunction() {
        TestFunctionRegistry.assertThatResolveFunction().among(TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")))).forParameters("bigint", "bigint").returns(this.functionSignature("bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithCoercion() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "double"), this.functionSignature("decimal(p,s)", "decimal(p,s)"), this.functionSignature("double", "double")).forParameters("bigint", "bigint").returns(this.functionSignature("decimal(19,0)", "decimal(19,0)"));
    }

    @Test
    public void testAmbiguousCallWithNoCoercion() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "decimal(p,s)"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"T", (Object)"T"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"T")))).forParameters("decimal(3,1)", "decimal(3,1)").returns(this.functionSignature("decimal(3,1)", "decimal(3,1)"));
    }

    @Test
    public void testAmbiguousCallWithCoercion() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("decimal(p,s)", "double"), this.functionSignature("double", "decimal(p,s)")).forParameters("bigint", "bigint").failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    @Test
    public void testResolveFunctionWithCoercionInTypes() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("array(decimal(p,s))", "array(double)"), this.functionSignature("array(decimal(p,s))", "array(decimal(p,s))"), this.functionSignature("array(double)", "array(double)")).forParameters("array(bigint)", "array(bigint)").returns(this.functionSignature("array(decimal(19,0))", "array(decimal(19,0))"));
    }

    @Test
    public void testResolveFunctionWithVariableArity() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("double", "double", "double"), this.functionSignature("decimal(p,s)").setVariableArity(true)).forParameters("bigint", "bigint", "bigint").returns(this.functionSignature("decimal(19,0)", "decimal(19,0)", "decimal(19,0)"));
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("double", "double", "double"), this.functionSignature("bigint").setVariableArity(true)).forParameters("bigint", "bigint", "bigint").returns(this.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionWithVariadicBound() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint", "bigint"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"T1", (Object)"T2", (Object)"T3"), "boolean", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound((String)"T1", (String)"decimal"), (Object)Signature.withVariadicBound((String)"T2", (String)"decimal"), (Object)Signature.withVariadicBound((String)"T3", (String)"decimal")))).forParameters("unknown", "bigint", "bigint").returns(this.functionSignature("bigint", "bigint", "bigint"));
    }

    @Test
    public void testResolveFunctionForUnknown() {
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint")).forParameters("unknown").returns(this.functionSignature("bigint"));
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint"), this.functionSignature("integer")).forParameters("unknown").returns(this.functionSignature("integer"));
        TestFunctionRegistry.assertThatResolveFunction().among(this.functionSignature("bigint", "bigint"), this.functionSignature("integer", "integer")).forParameters("unknown", "bigint").returns(this.functionSignature("bigint", "bigint"));
        TestFunctionRegistry.assertThatResolveFunction().among(TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "boolean"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "boolean")).forParameters("unknown").returns(this.functionSignature("integer"));
        TestFunctionRegistry.assertThatResolveFunction().among(TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"JoniRegExp"), "JoniRegExp"), TestFunctionRegistry.functionSignature((List<String>)ImmutableList.of((Object)"integer"), "integer")).forParameters("unknown").failsWithMessage("Could not choose a best candidate operator. Explicit type casts must be added.");
    }

    private SignatureBuilder functionSignature(String ... argumentTypes) {
        return TestFunctionRegistry.functionSignature((List<String>)ImmutableList.copyOf((Object[])argumentTypes), "boolean");
    }

    private static SignatureBuilder functionSignature(List<String> arguments, String returnType) {
        return TestFunctionRegistry.functionSignature(arguments, returnType, (List<TypeVariableConstraint>)ImmutableList.of());
    }

    private static SignatureBuilder functionSignature(List<String> arguments, String returnType, List<TypeVariableConstraint> typeVariableConstraints) {
        ImmutableSet literalParameters = ImmutableSet.of((Object)"p", (Object)"s", (Object)"p1", (Object)"s1", (Object)"p2", (Object)"s2", (Object[])new String[]{"p3", "s3"});
        List argumentSignatures = (List)arguments.stream().map(signature -> TypeSignature.parseTypeSignature((String)signature, (Set)literalParameters)).collect(ImmutableList.toImmutableList());
        return new SignatureBuilder().returnType(TypeSignature.parseTypeSignature((String)returnType, (Set)literalParameters)).argumentTypes(argumentSignatures).typeVariableConstraints(typeVariableConstraints).kind(FunctionKind.SCALAR);
    }

    private static ResolveFunctionAssertion assertThatResolveFunction() {
        return new ResolveFunctionAssertion();
    }

    public static final class ScalarSum {
        private ScalarSum() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long sum(@SqlType(value="bigint") long a, @SqlType(value="bigint") long b) {
            return a + b;
        }
    }

    private static class ResolveFunctionAssertion {
        private static final String TEST_FUNCTION_NAME = "TEST_FUNCTION_NAME";
        private final TypeRegistry typeRegistry = new TypeRegistry();
        private final BlockEncodingSerde blockEncoding = new BlockEncodingManager((TypeManager)this.typeRegistry, new BlockEncoding[0]);
        private List<SignatureBuilder> functionSignatures = ImmutableList.of();
        private List<TypeSignature> parameterTypes = ImmutableList.of();

        private ResolveFunctionAssertion() {
        }

        public ResolveFunctionAssertion among(SignatureBuilder ... functionSignatures) {
            this.functionSignatures = ImmutableList.copyOf((Object[])functionSignatures);
            return this;
        }

        public ResolveFunctionAssertion forParameters(String ... parameters) {
            this.parameterTypes = ResolveFunctionAssertion.parseTypeSignatures(parameters);
            return this;
        }

        public ResolveFunctionAssertion returns(SignatureBuilder functionSignature) {
            Signature expectedSignature = functionSignature.name(TEST_FUNCTION_NAME).build();
            Signature actualSignature = this.resolveSignature();
            Assert.assertEquals((Object)actualSignature, (Object)expectedSignature);
            return this;
        }

        public ResolveFunctionAssertion failsWithMessage(String ... messages) {
            try {
                this.resolveSignature();
                Assert.fail((String)"didn't fail as expected");
            }
            catch (RuntimeException e) {
                String actualMessage = e.getMessage();
                for (String expectedMessage : messages) {
                    if (actualMessage.contains(expectedMessage)) continue;
                    Assert.fail((String)String.format("%s doesn't contain %s", actualMessage, expectedMessage));
                }
            }
            return this;
        }

        private Signature resolveSignature() {
            FunctionRegistry functionRegistry = new FunctionRegistry((TypeManager)this.typeRegistry, this.blockEncoding, new FeaturesConfig());
            functionRegistry.addFunctions(this.createFunctionsFromSignatures());
            return functionRegistry.resolveFunction(QualifiedName.of((String)TEST_FUNCTION_NAME), TypeSignatureProvider.fromTypeSignatures(this.parameterTypes));
        }

        private List<SqlFunction> createFunctionsFromSignatures() {
            ImmutableList.Builder functions = ImmutableList.builder();
            for (SignatureBuilder functionSignature : this.functionSignatures) {
                Signature signature = functionSignature.name(TEST_FUNCTION_NAME).build();
                functions.add((Object)new SqlScalarFunction(signature){

                    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
                        return new ScalarFunctionImplementation(false, Collections.nCopies(arity, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), MethodHandles.identity(Void.class), true);
                    }

                    public boolean isHidden() {
                        return false;
                    }

                    public boolean isDeterministic() {
                        return false;
                    }

                    public String getDescription() {
                        return "testing function that does nothing";
                    }
                });
            }
            return functions.build();
        }

        private static List<TypeSignature> parseTypeSignatures(String ... signatures) {
            return ImmutableList.copyOf((Object[])signatures).stream().map(TypeSignature::parseTypeSignature).collect(Collectors.toList());
        }
    }
}

