/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPolymorphicScalarFunction {
    private static final TypeRegistry TYPE_REGISTRY = new TypeRegistry();
    private static final FunctionRegistry REGISTRY = new FunctionRegistry((TypeManager)TYPE_REGISTRY, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)TYPE_REGISTRY, new BlockEncoding[0]), new FeaturesConfig());
    private static final Signature SIGNATURE = Signature.builder().name("foo").kind(FunctionKind.SCALAR).returnType(TypeSignature.parseTypeSignature((String)"bigint")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
    private static final long INPUT_VARCHAR_LENGTH = 10L;
    private static final String INPUT_VARCHAR_SIGNATURE = "varchar(10)";
    private static final TypeSignature INPUT_VARCHAR_TYPE = TypeSignature.parseTypeSignature((String)"varchar(10)");
    private static final Slice INPUT_SLICE = Slices.allocate((int)Math.toIntExact(10L));
    private static final BoundVariables BOUND_VARIABLES = new BoundVariables((Map)ImmutableMap.of((Object)"V", (Object)TYPE_REGISTRY.getType(INPUT_VARCHAR_TYPE)), (Map)ImmutableMap.of((Object)"x", (Object)10L));

    @Test
    public void testSelectsMethodBasedOnArgumentTypes() throws Throwable {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).implementation(b -> b.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(b -> b.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)context.getLiteral("x")))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, (TypeManager)TYPE_REGISTRY, REGISTRY);
        Assert.assertEquals((Object)functionImplementation.getMethodHandle().invoke(INPUT_SLICE), (Object)10L);
    }

    @Test
    public void testSelectsMethodBasedOnReturnType() throws Throwable {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).implementation(b -> b.methods(new String[]{"varcharToVarcharCreateSliceWithExtraParameterLength"})).implementation(b -> b.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)42))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, (TypeManager)TYPE_REGISTRY, REGISTRY);
        Assert.assertEquals((Object)functionImplementation.getMethodHandle().invoke(INPUT_SLICE), (Object)42L);
    }

    @Test
    public void testSameLiteralInArgumentsAndReturnValue() throws Throwable {
        Signature signature = Signature.builder().name("foo").kind(FunctionKind.SCALAR).returnType(TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).implementation(b -> b.methods(new String[]{"varcharToVarchar"})).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, (TypeManager)TYPE_REGISTRY, REGISTRY);
        Slice slice = functionImplementation.getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testTypeParameters() throws Throwable {
        Signature signature = Signature.builder().name("foo").kind(FunctionKind.SCALAR).typeVariableConstraints(new TypeVariableConstraint[]{Signature.comparableWithVariadicBound((String)"V", (String)"varchar")}).returnType(TypeSignature.parseTypeSignature((String)"V")).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"V")}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).implementation(b -> b.methods(new String[]{"varcharToVarchar"})).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, (TypeManager)TYPE_REGISTRY, REGISTRY);
        Slice slice = functionImplementation.getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testSetsHiddenToTrueForOperators() {
        Signature signature = Signature.builder().operatorType(OperatorType.ADD).kind(FunctionKind.SCALAR).returnType(TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))).argumentTypes(new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).implementation(b -> b.methods(new String[]{"varcharToVarchar"})).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, (TypeManager)TYPE_REGISTRY, REGISTRY);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="method foo was not found in class com.facebook.presto.metadata.TestPolymorphicScalarFunction\\$TestMethods")
    public void testFailIfNotAllMethodsPresent() {
        SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).implementation(b -> b.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(b -> b.methods(new String[]{"foo"})).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="methods must be selected first")
    public void testFailNoMethodsAreSelectedWhenExtraParametersFunctionIsSet() {
        SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).implementation(b -> b.withExtraParameters(context -> ImmutableList.of((Object)42))).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="two matching methods \\(varcharToBigintReturnFirstExtraParameter and varcharToBigintReturnExtraParameter\\) for parameter types \\[varchar\\(10\\)\\]")
    public void testFailIfTwoMethodsWithSameArguments() {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).implementation(b -> b.methods(new String[]{"varcharToBigintReturnFirstExtraParameter"})).implementation(b -> b.methods(new String[]{"varcharToBigintReturnExtraParameter"})).build();
        function.specialize(BOUND_VARIABLES, 1, (TypeManager)TYPE_REGISTRY, REGISTRY);
    }

    public static class TestMethods {
        static final Slice VARCHAR_TO_VARCHAR_RETURN_VALUE = Slices.utf8Slice((String)"hello world");
        static final long VARCHAR_TO_BIGINT_RETURN_VALUE = 42L;

        public static Slice varcharToVarchar(Slice varchar) {
            return VARCHAR_TO_VARCHAR_RETURN_VALUE;
        }

        public static long varcharToBigint(Slice varchar) {
            return 42L;
        }

        public static long varcharToBigintReturnExtraParameter(Slice varchar, long extraParameter) {
            return extraParameter;
        }

        public static long bigintToBigintReturnExtraParameter(long bigint, int extraParameter) {
            return bigint;
        }

        public static long varcharToBigintReturnFirstExtraParameter(Slice varchar, long extraParameter1, int extraParameter2) {
            return extraParameter1;
        }

        public static Slice varcharToVarcharCreateSliceWithExtraParameterLength(Slice string, int extraParameter) {
            return Slices.allocate((int)extraParameter);
        }
    }
}

