/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignature {
    @Test
    public void testSerializationRoundTrip() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TypeRegistry())));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider, true).jsonCodec(Signature.class);
        Signature expected = new Signature("function", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"bigint"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"boolean"), (Object)TypeSignature.parseTypeSignature((String)"double"), (Object)TypeSignature.parseTypeSignature((String)"varchar")));
        String json = codec.toJson((Object)expected);
        Signature actual = (Signature)codec.fromJson(json);
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((Object)actual.getKind(), (Object)expected.getKind());
        Assert.assertEquals((Object)actual.getReturnType(), (Object)expected.getReturnType());
        Assert.assertEquals((Collection)actual.getArgumentTypes(), (Collection)expected.getArgumentTypes());
    }
}

