/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.execution.buffer.PartitionedOutputBuffer;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PartitionedOutputOperator;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPartitionedOutputOperator {
    @Benchmark
    public void addPage(BenchmarkData data) {
        PartitionedOutputOperator operator = data.createPartitionedOutputOperator();
        for (int i = 0; i < data.getPageCount(); ++i) {
            operator.addInput(data.getDataPage());
        }
        operator.finish();
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        new BenchmarkPartitionedOutputOperator().addPage(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).jvmArgs(new String[]{"-Xmx10g"}).include(".*" + BenchmarkPartitionedOutputOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int PAGE_COUNT = 5000;
        private static final int PARTITION_COUNT = 512;
        private static final int ENTRIES_PER_PAGE = 256;
        private static final DataSize MAX_MEMORY = new DataSize(1.0, DataSize.Unit.GIGABYTE);
        private static final RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR));
        private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)rowType, (Object)rowType, (Object)rowType);
        private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-EXECUTOR-%s"));
        private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"test-%s"));
        private final Page dataPage = this.createPage();

        private int getPageCount() {
            return 5000;
        }

        public Page getDataPage() {
            return this.dataPage;
        }

        private PartitionedOutputOperator createPartitionedOutputOperator() {
            LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new InterpretedHashGenerator((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}), 512);
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]), false);
            OutputBuffers buffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
            for (int partition = 0; partition < 512; ++partition) {
                buffers = buffers.withBuffer(new OutputBuffers.OutputBufferId(partition), partition);
            }
            PartitionedOutputBuffer buffer = this.createPartitionedBuffer(buffers.withNoMoreBufferIds(), new DataSize(9.223372036854776E18, DataSize.Unit.BYTE));
            PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory((PartitionFunction)partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty()), false, OptionalInt.empty(), (OutputBuffer)buffer, new DataSize(1.0, DataSize.Unit.GIGABYTE));
            return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), TYPES, Function.identity(), serdeFactory).createOperator(this.createDriverContext());
        }

        private Page createPage() {
            List<Object>[] testRows = this.generateTestRows((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), 256);
            PageBuilder pageBuilder = new PageBuilder(TYPES);
            BlockBuilder bigintBlockBuilder = pageBuilder.getBlockBuilder(0);
            BlockBuilder rowBlockBuilder = pageBuilder.getBlockBuilder(1);
            BlockBuilder rowBlockBuilder2 = pageBuilder.getBlockBuilder(2);
            BlockBuilder rowBlockBuilder3 = pageBuilder.getBlockBuilder(3);
            for (int i = 0; i < 256; ++i) {
                BigintType.BIGINT.writeLong(bigintBlockBuilder, (long)i);
                this.writeRow(testRows[i], rowBlockBuilder);
                this.writeRow(testRows[i], rowBlockBuilder2);
                this.writeRow(testRows[i], rowBlockBuilder3);
            }
            pageBuilder.declarePositions(256);
            return pageBuilder.build();
        }

        private void writeRow(List<Object> testRow, BlockBuilder rowBlockBuilder) {
            BlockBuilder singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            for (Object fieldValue : testRow) {
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(singleRowBlockWriter, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            rowBlockBuilder.closeEntry();
        }

        private List<Object>[] generateTestRows(List<Type> fieldTypes, int numRows) {
            List[] testRows = new List[numRows];
            for (int i = 0; i < numRows; ++i) {
                ArrayList<String> testRow = new ArrayList<String>(fieldTypes.size());
                for (int j = 0; j < fieldTypes.size(); ++j) {
                    if (fieldTypes.get(j) != VarcharType.VARCHAR) {
                        throw new UnsupportedOperationException();
                    }
                    byte[] data = new byte[ThreadLocalRandom.current().nextInt(128)];
                    ThreadLocalRandom.current().nextBytes(data);
                    testRow.add(new String(data));
                }
                testRows[i] = testRow;
            }
            return testRows;
        }

        private DriverContext createDriverContext() {
            return TestingTaskContext.builder((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULER, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(MAX_MEMORY).build().addPipelineContext(0, true, true).addDriverContext();
        }

        private PartitionedOutputBuffer createPartitionedBuffer(OutputBuffers buffers, DataSize dataSize) {
            return new PartitionedOutputBuffer("task-instance-id", new StateMachine("bufferState", (Executor)SCHEDULER, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), buffers, dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)SCHEDULER);
        }
    }
}

