/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

public final class GenericLongFunction
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(GenericLongFunction.class, (String)"apply", (Class[])new Class[]{LongUnaryOperator.class, Long.TYPE});
    private final LongUnaryOperator longUnaryOperator;

    GenericLongFunction(String suffix, LongUnaryOperator longUnaryOperator) {
        super(Signature.internalScalarFunction((String)("generic_long_" + Objects.requireNonNull(suffix, "suffix is null")), (TypeSignature)TypeSignature.parseTypeSignature((String)"bigint"), (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        this.longUnaryOperator = longUnaryOperator;
    }

    public boolean isHidden() {
        return true;
    }

    public boolean isDeterministic() {
        return true;
    }

    public String getDescription() {
        return "generic long function for test";
    }

    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.longUnaryOperator);
        return new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    public static long apply(LongUnaryOperator longUnaryOperator, long value) {
        return longUnaryOperator.applyAsLong(value);
    }
}

