/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.RowBlockBuilder;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.IntStream;

public final class OperatorAssertion {
    private static final Duration BLOCKED_DEFAULT_TIMEOUT = new Duration(10.0, TimeUnit.MILLISECONDS);
    private static final Duration UNBLOCKED_DEFAULT_TIMEOUT = new Duration(1.0, TimeUnit.SECONDS);

    private OperatorAssertion() {
    }

    public static List<Page> toPages(Operator operator, Iterator<Page> input) {
        return ImmutableList.builder().addAll(OperatorAssertion.toPagesPartial(operator, input)).addAll(OperatorAssertion.finishOperator(operator)).build();
    }

    public static List<Page> toPagesPartial(Operator operator, Iterator<Page> input) {
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        ImmutableList.Builder outputPages = ImmutableList.builder();
        for (int loopsSinceLastPage = 0; loopsSinceLastPage < 1000; ++loopsSinceLastPage) {
            Page outputPage;
            if (OperatorAssertion.handledBlocked(operator)) continue;
            OperatorAssertion.handleMemoryRevoking(operator);
            if (input.hasNext() && operator.needsInput()) {
                operator.addInput(input.next());
                loopsSinceLastPage = 0;
            }
            if ((outputPage = operator.getOutput()) == null || outputPage.getPositionCount() == 0) continue;
            outputPages.add((Object)outputPage);
            loopsSinceLastPage = 0;
        }
        return outputPages.build();
    }

    public static List<Page> finishOperator(Operator operator) {
        ImmutableList.Builder outputPages = ImmutableList.builder();
        for (int loopsSinceLastPage = 0; !operator.isFinished() && loopsSinceLastPage < 1000; ++loopsSinceLastPage) {
            if (OperatorAssertion.handledBlocked(operator)) continue;
            OperatorAssertion.handleMemoryRevoking(operator);
            operator.finish();
            Page outputPage = operator.getOutput();
            if (outputPage == null || outputPage.getPositionCount() == 0) continue;
            outputPages.add((Object)outputPage);
            loopsSinceLastPage = 0;
        }
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)true, (String)"Operator did not finish");
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false, (String)"Operator still wants input");
        Assert.assertEquals((boolean)operator.isBlocked().isDone(), (boolean)true, (String)"Operator is blocked");
        return outputPages.build();
    }

    private static boolean handledBlocked(Operator operator) {
        ListenableFuture isBlocked = operator.isBlocked();
        if (!isBlocked.isDone()) {
            MoreFutures.tryGetFutureValue((Future)isBlocked, (int)1, (TimeUnit)TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    private static void handleMemoryRevoking(Operator operator) {
        if (operator.getOperatorContext().getReservedRevocableBytes() > 0L) {
            MoreFutures.getFutureValue((Future)operator.startMemoryRevoke());
            operator.finishMemoryRevoke();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Page> toPages(OperatorFactory operatorFactory, DriverContext driverContext, List<Page> input) {
        try (Operator operator = operatorFactory.createOperator(driverContext);){
            List<Page> list = OperatorAssertion.toPages(operator, input.iterator());
            return list;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Page> toPages(OperatorFactory operatorFactory, DriverContext driverContext) {
        return OperatorAssertion.toPages(operatorFactory, driverContext, (List<Page>)ImmutableList.of());
    }

    public static MaterializedResult toMaterializedResult(Session session, List<Type> types, List<Page> pages) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)session, types);
        for (Page outputPage : pages) {
            resultBuilder.page(outputPage);
        }
        return resultBuilder.build();
    }

    public static Block toRow(List<Type> parameterTypes, Object ... values) {
        Preconditions.checkArgument((parameterTypes.size() == values.length ? 1 : 0) != 0, (Object)("parameterTypes.size(" + parameterTypes.size() + ") does not equal to values.length(" + values.length + ")"));
        RowType rowType = RowType.anonymous(parameterTypes);
        RowBlockBuilder blockBuilder = new RowBlockBuilder(parameterTypes, null, 1);
        BlockBuilder singleRowBlockWriter = blockBuilder.beginBlockEntry();
        for (int i = 0; i < values.length; ++i) {
            StructuralTestUtil.appendToBlockBuilder(parameterTypes.get(i), values[i], singleRowBlockWriter);
        }
        blockBuilder.closeEntry();
        return rowType.getObject((Block)blockBuilder, 0);
    }

    public static void assertOperatorEquals(OperatorFactory operatorFactory, List<Type> types, DriverContext driverContext, List<Page> input, List<Page> expected) {
        List<Page> actual = OperatorAssertion.toPages(operatorFactory, driverContext, input);
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < actual.size(); ++i) {
            PageAssertions.assertPageEquals(types, actual.get(i), expected.get(i));
        }
    }

    public static void assertOperatorEquals(OperatorFactory operatorFactory, DriverContext driverContext, List<Page> input, MaterializedResult expected) {
        OperatorAssertion.assertOperatorEquals(operatorFactory, driverContext, input, expected, false, (List<Integer>)ImmutableList.of());
    }

    public static void assertOperatorEquals(OperatorFactory operatorFactory, DriverContext driverContext, List<Page> input, MaterializedResult expected, boolean hashEnabled, List<Integer> hashChannels) {
        List<Page> pages = OperatorAssertion.toPages(operatorFactory, driverContext, input);
        if (hashEnabled && !hashChannels.isEmpty()) {
            pages = OperatorAssertion.dropChannel(pages, hashChannels);
        }
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), expected.getTypes(), pages);
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    public static void assertOperatorEqualsIgnoreOrder(OperatorFactory operatorFactory, DriverContext driverContext, List<Page> input, MaterializedResult expected) {
        OperatorAssertion.assertOperatorEqualsIgnoreOrder(operatorFactory, driverContext, input, expected, false, Optional.empty());
    }

    public static void assertOperatorEqualsIgnoreOrder(OperatorFactory operatorFactory, DriverContext driverContext, List<Page> input, MaterializedResult expected, boolean hashEnabled, Optional<Integer> hashChannel) {
        List<Page> pages = OperatorAssertion.toPages(operatorFactory, driverContext, input);
        if (hashEnabled && hashChannel.isPresent()) {
            pages = OperatorAssertion.dropChannel(pages, (List<Integer>)ImmutableList.of((Object)hashChannel.get()));
        }
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), expected.getTypes(), pages);
        Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
    }

    public static void assertOperatorIsBlocked(Operator operator) {
        OperatorAssertion.assertOperatorIsBlocked(operator, BLOCKED_DEFAULT_TIMEOUT);
    }

    public static void assertOperatorIsBlocked(Operator operator, Duration timeout) {
        if (OperatorAssertion.waitForOperatorToUnblock(operator, timeout)) {
            org.testng.Assert.fail((String)("Operator is expected to be blocked for at least " + timeout.toString()));
        }
    }

    public static void assertOperatorIsUnblocked(Operator operator) {
        OperatorAssertion.assertOperatorIsUnblocked(operator, UNBLOCKED_DEFAULT_TIMEOUT);
    }

    public static void assertOperatorIsUnblocked(Operator operator, Duration timeout) {
        if (!OperatorAssertion.waitForOperatorToUnblock(operator, timeout)) {
            org.testng.Assert.fail((String)("Operator is expected to be unblocked within " + timeout.toString()));
        }
    }

    private static boolean waitForOperatorToUnblock(Operator operator, Duration timeout) {
        try {
            operator.isBlocked().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException expected) {
            return false;
        }
    }

    static <T> List<T> without(List<T> list, Collection<Integer> indexes) {
        ImmutableSet indexesSet = ImmutableSet.copyOf(indexes);
        return (List)IntStream.range(0, list.size()).filter(arg_0 -> OperatorAssertion.lambda$without$0((Set)indexesSet, arg_0)).mapToObj(list::get).collect(ImmutableList.toImmutableList());
    }

    static List<Page> dropChannel(List<Page> pages, List<Integer> channels) {
        ArrayList<Page> actualPages = new ArrayList<Page>();
        for (Page page : pages) {
            int channel = 0;
            Block[] blocks = new Block[page.getChannelCount() - channels.size()];
            for (int i = 0; i < page.getChannelCount(); ++i) {
                if (channels.contains(i)) continue;
                blocks[channel++] = page.getBlock(i);
            }
            actualPages.add(new Page(blocks));
        }
        return actualPages;
    }

    private static /* synthetic */ boolean lambda$without$0(Set indexesSet, int index) {
        return !indexesSet.contains(index);
    }
}

