/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.TaskSource;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.PageConsumerOperator;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDriver {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNormalFinish() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        ValuesOperator source = new ValuesOperator(this.driverContext.addOperatorContext(0, new PlanNodeId("test"), "values"), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).addSequencePage(10, 20, 30, 40).build());
        PageConsumerOperator sink = this.createSinkOperator((List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)this.driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        ListenableFuture blocked = driver.processFor(new Duration(1.0, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)blocked.isDone());
        Assert.assertTrue((boolean)driver.isFinished());
        Assert.assertTrue((boolean)sink.isFinished());
        Assert.assertTrue((boolean)source.isFinished());
    }

    @Test(invocationCount=1000, timeOut=1000L)
    public void testConcurrentClose() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        OperatorContext operatorContext = this.driverContext.addOperatorContext(0, new PlanNodeId("test"), "values");
        ValuesOperator source = new ValuesOperator(operatorContext, RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).addSequencePage(10, 20, 30, 40).build());
        PageConsumerOperator sink = this.createSinkOperator((List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        this.scheduledExecutor.submit(() -> driver.processFor(new Duration(1.0, TimeUnit.NANOSECONDS)));
        this.scheduledExecutor.submit(() -> driver.close());
        while (!this.driverContext.isDone()) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    @Test
    public void testAbruptFinish() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        ValuesOperator source = new ValuesOperator(this.driverContext.addOperatorContext(0, new PlanNodeId("test"), "values"), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).addSequencePage(10, 20, 30, 40).build());
        PageConsumerOperator sink = this.createSinkOperator((List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)this.driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        driver.close();
        Assert.assertTrue((boolean)driver.isFinished());
        Assert.assertFalse((boolean)source.isFinished());
        Assert.assertFalse((boolean)sink.isFinished());
        Assert.assertTrue((boolean)sink.isClosed());
    }

    @Test
    public void testAddSourceFinish() {
        PlanNodeId sourceId = new PlanNodeId("source");
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        TableScanOperator source = new TableScanOperator(this.driverContext.addOperatorContext(99, new PlanNodeId("test"), "values"), sourceId, new PageSourceProvider((List)types){
            final /* synthetic */ List val$types;
            {
                this.val$types = list;
            }

            public ConnectorPageSource createPageSource(Session session, Split split, List<ColumnHandle> columns) {
                return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(this.val$types).addSequencePage(10, 20, 30, 40).build());
            }
        }, (Iterable)ImmutableList.of());
        PageConsumerOperator sink = this.createSinkOperator((List<Type>)types);
        Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{sink});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)this.driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertFalse((boolean)driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        Assert.assertFalse((boolean)driver.isFinished());
        driver.updateSource(new TaskSource(sourceId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, sourceId, TestDriver.newMockSplit())), true));
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.SECONDS)).isDone());
        Assert.assertTrue((boolean)driver.isFinished());
        Assert.assertTrue((boolean)sink.isFinished());
        Assert.assertTrue((boolean)source.isFinished());
    }

    @Test
    public void testBrokenOperatorCloseWhileProcessing() throws Exception {
        BrokenOperator brokenOperator = new BrokenOperator(this.driverContext.addOperatorContext(0, new PlanNodeId("test"), "source"), false);
        final Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)brokenOperator, (Operator[])new Operator[]{this.createSinkOperator((List<Type>)ImmutableList.of())});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)this.driverContext);
        Future<Boolean> driverProcessFor = this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone();
            }
        });
        brokenOperator.waitForLocked();
        driver.close();
        Assert.assertTrue((boolean)driver.isFinished());
        try {
            driverProcessFor.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected InterruptedException");
        }
        catch (ExecutionException e) {
            this.assertDriverInterrupted(e.getCause());
        }
    }

    @Test
    public void testBrokenOperatorProcessWhileClosing() throws Exception {
        BrokenOperator brokenOperator = new BrokenOperator(this.driverContext.addOperatorContext(0, new PlanNodeId("test"), "source"), true);
        final Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)brokenOperator, (Operator[])new Operator[]{this.createSinkOperator((List<Type>)ImmutableList.of())});
        Assert.assertSame((Object)driver.getDriverContext(), (Object)this.driverContext);
        Future<Boolean> driverClose = this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                driver.close();
                return true;
            }
        });
        brokenOperator.waitForLocked();
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        Assert.assertTrue((boolean)driver.isFinished());
        brokenOperator.unlock();
        Assert.assertTrue((boolean)driverClose.get());
    }

    @Test
    public void testMemoryRevocationRace() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        AlwaysBlockedMemoryRevokingTableScanOperator source = new AlwaysBlockedMemoryRevokingTableScanOperator(this.driverContext.addOperatorContext(99, new PlanNodeId("test"), "scan"), new PlanNodeId("source"), new PageSourceProvider((List)types){
            final /* synthetic */ List val$types;
            {
                this.val$types = list;
            }

            public ConnectorPageSource createPageSource(Session session, Split split, List<ColumnHandle> columns) {
                return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(this.val$types).addSequencePage(10, 20, 30, 40).build());
            }
        }, (Iterable<ColumnHandle>)ImmutableList.of());
        Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{this.createSinkOperator((List<Type>)types)});
        Assert.assertTrue((boolean)driver.processFor(new Duration(100.0, TimeUnit.MILLISECONDS)).isDone());
    }

    @Test
    public void testBrokenOperatorAddSource() throws Exception {
        PlanNodeId sourceId = new PlanNodeId("source");
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        NotBlockedTableScanOperator source = new NotBlockedTableScanOperator(this.driverContext.addOperatorContext(99, new PlanNodeId("test"), "values"), sourceId, new PageSourceProvider((List)types){
            final /* synthetic */ List val$types;
            {
                this.val$types = list;
            }

            public ConnectorPageSource createPageSource(Session session, Split split, List<ColumnHandle> columns) {
                return new FixedPageSource(RowPagesBuilder.rowPagesBuilder(this.val$types).addSequencePage(10, 20, 30, 40).build());
            }
        }, (Iterable<ColumnHandle>)ImmutableList.of());
        BrokenOperator brokenOperator = new BrokenOperator(this.driverContext.addOperatorContext(0, new PlanNodeId("test"), "source"));
        final Driver driver = Driver.createDriver((DriverContext)this.driverContext, (Operator)source, (Operator[])new Operator[]{brokenOperator});
        Future<Boolean> driverProcessFor = this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone();
            }
        });
        brokenOperator.waitForLocked();
        Assert.assertSame((Object)driver.getDriverContext(), (Object)this.driverContext);
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.MILLISECONDS)).isDone());
        Assert.assertFalse((boolean)driver.isFinished());
        driver.updateSource(new TaskSource(sourceId, (Set)ImmutableSet.of((Object)new ScheduledSplit(0L, sourceId, TestDriver.newMockSplit())), true));
        Assert.assertFalse((boolean)driver.isFinished());
        Assert.assertTrue((boolean)driver.processFor(new Duration(1.0, TimeUnit.SECONDS)).isDone());
        Assert.assertFalse((boolean)driver.isFinished());
        driver.close();
        Assert.assertTrue((boolean)driver.isFinished());
        try {
            driverProcessFor.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected InterruptedException");
        }
        catch (ExecutionException e) {
            this.assertDriverInterrupted(e.getCause());
        }
    }

    private void assertDriverInterrupted(Throwable cause) {
        Preconditions.checkArgument((boolean)(cause instanceof PrestoException), (Object)"Expected root cause exception to be an instance of PrestoException");
        Assert.assertEquals((Object)((PrestoException)cause).getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertEquals((String)cause.getMessage(), (String)"Driver was interrupted");
    }

    private static Split newMockSplit() {
        return new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new MockSplit());
    }

    private PageConsumerOperator createSinkOperator(List<Type> types) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), types);
        return new PageConsumerOperator(this.driverContext.addOperatorContext(1, new PlanNodeId("test"), "sink"), arg_0 -> ((MaterializedResult.Builder)resultBuilder).page(arg_0), Function.identity());
    }

    private static class MockSplit
    implements ConnectorSplit {
        private MockSplit() {
        }

        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return null;
        }
    }

    private static class NotBlockedTableScanOperator
    extends TableScanOperator {
        public NotBlockedTableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, PageSourceProvider pageSourceProvider, Iterable<ColumnHandle> columns) {
            super(operatorContext, planNodeId, pageSourceProvider, columns);
        }

        public ListenableFuture<?> isBlocked() {
            return NOT_BLOCKED;
        }
    }

    private static class AlwaysBlockedMemoryRevokingTableScanOperator
    extends TableScanOperator {
        public AlwaysBlockedMemoryRevokingTableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, PageSourceProvider pageSourceProvider, Iterable<ColumnHandle> columns) {
            super(operatorContext, planNodeId, pageSourceProvider, columns);
        }

        public ListenableFuture<?> isBlocked() {
            LocalMemoryContext revocableMemoryContext = this.getOperatorContext().localRevocableMemoryContext();
            revocableMemoryContext.setBytes(100L);
            this.getOperatorContext().requestMemoryRevoking();
            return SettableFuture.create();
        }
    }

    private static class BrokenOperator
    implements Operator,
    Closeable {
        private final OperatorContext operatorContext;
        private final ReentrantLock lock = new ReentrantLock();
        private final CountDownLatch lockedLatch = new CountDownLatch(1);
        private final CountDownLatch unlockLatch = new CountDownLatch(1);
        private final boolean lockForClose;

        private BrokenOperator(OperatorContext operatorContext) {
            this(operatorContext, false);
        }

        private BrokenOperator(OperatorContext operatorContext, boolean lockForClose) {
            this.operatorContext = operatorContext;
            this.lockForClose = lockForClose;
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public void unlock() {
            this.unlockLatch.countDown();
        }

        private void waitForLocked() {
            try {
                Assert.assertTrue((boolean)this.lockedLatch.await(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted", e);
            }
        }

        private void waitForUnlock() {
            try {
                Assert.assertTrue((boolean)this.lock.tryLock(1L, TimeUnit.SECONDS));
                try {
                    this.lockedLatch.countDown();
                    Assert.assertTrue((boolean)this.unlockLatch.await(5L, TimeUnit.SECONDS));
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted", e);
            }
        }

        public void finish() {
            this.waitForUnlock();
        }

        public boolean isFinished() {
            this.waitForUnlock();
            return true;
        }

        public ListenableFuture<?> isBlocked() {
            this.waitForUnlock();
            return NOT_BLOCKED;
        }

        public boolean needsInput() {
            this.waitForUnlock();
            return false;
        }

        public void addInput(Page page) {
            this.waitForUnlock();
        }

        public Page getOutput() {
            this.waitForUnlock();
            return null;
        }

        @Override
        public void close() {
            if (this.lockForClose) {
                this.waitForUnlock();
            }
        }
    }
}

