/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TestOperatorStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriverStats {
    public static final DriverStats EXPECTED = new DriverStats(Lifespan.driverGroup((int)21), new DateTime(1L), new DateTime(2L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), new DataSize(6.0, DataSize.Unit.BYTE), new DataSize(7.0, DataSize.Unit.BYTE), new DataSize(8.0, DataSize.Unit.BYTE), new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(12.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), new DataSize(13.0, DataSize.Unit.BYTE), 14L, new Duration(15.0, TimeUnit.NANOSECONDS), new DataSize(16.0, DataSize.Unit.BYTE), 17L, new DataSize(18.0, DataSize.Unit.BYTE), 19L, new DataSize(20.0, DataSize.Unit.BYTE), (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(DriverStats.class);
        String json = codec.toJson((Object)EXPECTED);
        DriverStats actual = (DriverStats)codec.fromJson(json);
        TestDriverStats.assertExpectedDriverStats(actual);
    }

    public static void assertExpectedDriverStats(DriverStats actual) {
        Assert.assertEquals((Object)actual.getLifespan(), (Object)Lifespan.driverGroup((int)21));
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(6.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(7.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(8.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(13.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)14L);
        Assert.assertEquals((Object)actual.getRawInputReadTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(16.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)17L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)19L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(20.0, DataSize.Unit.BYTE));
        Assert.assertEquals((int)actual.getOperatorStats().size(), (int)1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorStats().get(0));
    }
}

