/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFilterAndProjectOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void test() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).addSequencePage(100, 0, 0).build();
        CallExpression filter = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.BETWEEN, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature())), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT), Expressions.constant((Object)19L, (Type)BigintType.BIGINT)});
        InputReferenceExpression field0 = Expressions.field((int)0, (Type)VarcharType.VARCHAR);
        CallExpression add5 = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.ADD, (TypeSignature)BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature())), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)BigintType.BIGINT), Expressions.constant((Object)5L, (Type)BigintType.BIGINT)});
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
        Supplier processor = compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)field0, (Object)add5));
        FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, new PlanNodeId("test"), processor, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"10", 15L}).row(new Object[]{"11", 16L}).row(new Object[]{"12", 17L}).row(new Object[]{"13", 18L}).row(new Object[]{"14", 19L}).row(new Object[]{"15", 20L}).row(new Object[]{"16", 21L}).row(new Object[]{"17", 22L}).row(new Object[]{"18", 23L}).row(new Object[]{"19", 24L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testMergeOutput() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).addSequencePage(100, 0, 0).addSequencePage(100, 0, 0).addSequencePage(100, 0, 0).addSequencePage(100, 0, 0).build();
        CallExpression filter = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature())), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
        Supplier processor = compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)1, (Type)BigintType.BIGINT)));
        FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, new PlanNodeId("test"), processor, (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(64.0, DataSize.Unit.KILOBYTE), 2);
        List<Page> expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(10L).row(10L).row(10L).row(10L).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), this.driverContext, input, expected);
    }
}

