/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinBridgeDataManager;
import com.facebook.presto.operator.NestedLoopBuildOperator;
import com.facebook.presto.operator.NestedLoopJoinPages;
import com.facebook.presto.operator.NestedLoopJoinPagesBridge;
import com.facebook.presto.operator.NestedLoopJoinPagesSupplier;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNestedLoopBuildOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNestedLoopBuild() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        JoinBridgeDataManager nestedLoopJoinPagesSupplierManager = JoinBridgeDataManager.nestedLoop((PipelineExecutionStrategy)PipelineExecutionStrategy.UNGROUPED_EXECUTION, (PipelineExecutionStrategy)PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinPagesSupplierManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinPagesBridge nestedLoopJoinPagesBridge = (NestedLoopJoinPagesBridge)nestedLoopJoinPagesSupplierManager.forLifespan(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinPagesBridge.getPagesFuture().isDone());
        Page buildPage1 = new Page(3, new Block[]{BlockAssertions.createLongSequenceBlock(11, 14)});
        Page buildPageEmpty = new Page(0, new Block[0]);
        Page buildPage2 = new Page(3000, new Block[]{BlockAssertions.createLongSequenceBlock(4000, 7000)});
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinPagesBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinPagesBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals(buildPages.get(0), (Object)buildPage1);
        Assert.assertEquals(buildPages.get(1), (Object)buildPage2);
        Assert.assertEquals((int)buildPages.size(), (int)2);
    }

    @Test
    public void testNestedLoopBuildNoBlock() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of();
        JoinBridgeDataManager nestedLoopJoinPagesSupplierManager = JoinBridgeDataManager.nestedLoop((PipelineExecutionStrategy)PipelineExecutionStrategy.UNGROUPED_EXECUTION, (PipelineExecutionStrategy)PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinPagesSupplierManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinPagesBridge nestedLoopJoinPagesBridge = (NestedLoopJoinPagesBridge)nestedLoopJoinPagesSupplierManager.forLifespan(Lifespan.taskWide());
        Assert.assertFalse((boolean)nestedLoopJoinPagesBridge.getPagesFuture().isDone());
        Page buildPage1 = new Page(3, new Block[0]);
        Page buildPageEmpty = new Page(0, new Block[0]);
        Page buildPage2 = new Page(3000, new Block[0]);
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assert.assertTrue((boolean)nestedLoopJoinPagesBridge.getPagesFuture().isDone());
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinPagesBridge.getPagesFuture().get()).getPages();
        Assert.assertEquals(buildPages.get(0), (Object)buildPage1);
        Assert.assertEquals(buildPages.get(1), (Object)buildPage2);
        Assert.assertEquals((int)buildPages.size(), (int)2);
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }
}

