/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPagesIndex {
    @Test
    public void testEstimatedSize() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
        PagesIndex pagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 30, false);
        long initialEstimatedSize = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertTrue((initialEstimatedSize > 0L ? 1 : 0) != 0, (String)String.format("Initial estimated size must be positive, got %s", initialEstimatedSize));
        pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
        long estimatedSizeWithOnePage = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertTrue((estimatedSizeWithOnePage > initialEstimatedSize ? 1 : 0) != 0, (String)"Estimated size should grow after adding a page");
        pagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
        long estimatedSizeWithTwoPages = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertEquals((long)estimatedSizeWithTwoPages, (long)(initialEstimatedSize + (estimatedSizeWithOnePage - initialEstimatedSize) * 2L), (String)"Estimated size should grow linearly as long as we don't pass expectedPositions");
        pagesIndex.compact();
        long estimatedSizeAfterCompact = pagesIndex.getEstimatedSize().toBytes();
        Assert.assertTrue((estimatedSizeAfterCompact < estimatedSizeWithTwoPages ? 1 : 0) != 0, (String)String.format("Compact should reduce (or retain) size, but changed from %s to %s", estimatedSizeWithTwoPages, estimatedSizeAfterCompact));
    }

    @Test
    public void testEagerCompact() {
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        PagesIndex lazyCompactPagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, false);
        PagesIndex eagerCompactPagesIndex = TestPagesIndex.newPagesIndex((List<Type>)types, 50, true);
        for (int i = 0; i < 5; ++i) {
            lazyCompactPagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
            eagerCompactPagesIndex.addPage(TestPagesIndex.somePage((List<Type>)types));
            Assert.assertTrue((eagerCompactPagesIndex.getEstimatedSize().toBytes() < lazyCompactPagesIndex.getEstimatedSize().toBytes() ? 1 : 0) != 0, (String)"Expect eagerCompactPagesIndex retained less data than lazyCompactPagesIndex after adding the page, because the pages used in the test are compactable.");
        }
        lazyCompactPagesIndex.compact();
        Assert.assertEquals((Object)lazyCompactPagesIndex.getEstimatedSize(), (Object)eagerCompactPagesIndex.getEstimatedSize());
    }

    private static PagesIndex newPagesIndex(List<Type> types, int expectedPositions, boolean eagerCompact) {
        return new PagesIndex.TestingFactory(eagerCompact).newPagesIndex(types, expectedPositions);
    }

    private static Page somePage(List<Type> types) {
        int[] initialValues = new int[types.size()];
        Arrays.setAll(initialValues, i -> 100 * i);
        return SequencePageBuilder.createSequencePage(types, 7, initialValues);
    }
}

