/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TestDriverStats;
import com.facebook.presto.operator.TestOperatorStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPipelineStats {
    public static final PipelineStats EXPECTED = new PipelineStats(0, new DateTime(100L), new DateTime(101L), new DateTime(102L), true, false, 1, 2, 1, 3, 2, 19, 4, new DataSize(5.0, DataSize.Unit.BYTE), new DataSize(6.0, DataSize.Unit.BYTE), new DataSize(7.0, DataSize.Unit.BYTE), TestPipelineStats.getTestDistribution(8), TestPipelineStats.getTestDistribution(9), new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(11.0, TimeUnit.NANOSECONDS), new Duration(13.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), new DataSize(14.0, DataSize.Unit.BYTE), 15L, new DataSize(16.0, DataSize.Unit.BYTE), 17L, new DataSize(18.0, DataSize.Unit.BYTE), 19L, new DataSize(20.0, DataSize.Unit.BYTE), (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED), (List)ImmutableList.of((Object)TestDriverStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(PipelineStats.class);
        String json = codec.toJson((Object)EXPECTED);
        PipelineStats actual = (PipelineStats)codec.fromJson(json);
        TestPipelineStats.assertExpectedPipelineStats(actual);
    }

    public static void assertExpectedPipelineStats(PipelineStats actual) {
        Assert.assertEquals((Object)actual.getFirstStartTime(), (Object)new DateTime(100L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastStartTime(), (Object)new DateTime(101L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastEndTime(), (Object)new DateTime(102L, DateTimeZone.UTC));
        Assert.assertEquals((boolean)actual.isInputPipeline(), (boolean)true);
        Assert.assertEquals((boolean)actual.isOutputPipeline(), (boolean)false);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)1);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)2);
        Assert.assertEquals((int)actual.getQueuedPartitionedDrivers(), (int)1);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)3);
        Assert.assertEquals((int)actual.getRunningPartitionedDrivers(), (int)2);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)19);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)4);
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(5.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(6.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(7.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getQueuedTime().getCount(), (Object)8.0);
        Assert.assertEquals((Object)actual.getElapsedTime().getCount(), (Object)9.0);
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(11.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(13.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(14.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)15L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(16.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)17L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)19L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(20.0, DataSize.Unit.BYTE));
        Assert.assertEquals((int)actual.getOperatorSummaries().size(), (int)1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorSummaries().get(0));
        Assert.assertEquals((int)actual.getDrivers().size(), (int)1);
        TestDriverStats.assertExpectedDriverStats((DriverStats)actual.getDrivers().get(0));
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }
}

