/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRealAverageAggregation
extends AbstractTestAggregationFunction {
    private InternalAggregationFunction avgFunction;

    @BeforeClass
    public void setUp() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.avgFunction = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("avg", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"real"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"real")}));
    }

    @Test
    public void averageOfNullIsNull() {
        AggregationTestUtils.assertAggregation(this.avgFunction, null, BlockAssertions.createBlockOfReals(null, null));
    }

    @Test
    public void averageOfSingleValueEqualsThatValue() {
        AggregationTestUtils.assertAggregation(this.avgFunction, (Object)Float.valueOf(1.23f), BlockAssertions.createBlockOfReals(Float.valueOf(1.23f)));
    }

    @Test
    public void averageOfTwoMaxFloatsEqualsMaxFloat() {
        AggregationTestUtils.assertAggregation(this.avgFunction, (Object)Float.valueOf(Float.MAX_VALUE), BlockAssertions.createBlockOfReals(Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MAX_VALUE)));
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"real");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        float sum = 0.0f;
        for (int i = start; i < start + length; ++i) {
            sum += (float)i;
        }
        return Float.valueOf(sum / (float)length);
    }
}

